<?php

namespace routes;

use model\Startups;
use Api\BaseRouter;
use model\VoucherCodes;
use model\VoucherUseCodes;
use FwRoutingSystem\Router;
use model\VoucherCodeServices;
use model\VoucherCodeProviders;
use model\Entity\StartupsEntity;
use model\Entity\VoucherCodesEntity;
use model\Entity\VoucherCodeServicesEntity;
use model\Entity\VoucherCodeProvidersEntity;

class VoucherCodesRoute extends BaseRouter {
	public $groupPath = 'voucher-codes';
	
	public function routes(Router $router) {
		$router->post('/providers', $this->middleware($router), function () {
			$userId = $this->getParam('userId');
			$output = [];
			foreach (VoucherCodeServices::getAll() as $voucherCodeService) {
				$code = VoucherCodes::get($voucherCodeService->code_id);
				/** @var VoucherCodesEntity $code */
				$providerId = $code->code_provider_id;
				$provider = VoucherCodeProviders::get($providerId);
				$uniqueCode = "$providerId" . "_$code->percent";
				/** @var VoucherCodeProvidersEntity $provider */
				$data = $provider->apiFormat();
				$data['percent'] = $code->percent;
				$data['expireDate'] = date("Y/m/d H:i:s", $voucherCodeService->code_service_expire_date);
				$data['description'] = $code->description;
				$data['code'] = $uniqueCode;
				if (VoucherUseCodes::Db()->where([
						'code_id_generated'    => $uniqueCode,
						'voucher_code_user_id' => $userId,
					])->rowCount() == 0) {
					$output[$uniqueCode] = $data;
				}
			}
			return response(array_values($output));
		});
		$router->post('/single', $this->middleware($router), function () {
			$providerCode = $this->getParam('providerCode');
			$userId = $this->getParam('userId');
			$providerId = explode('_', $providerCode)[0];
			$percent = explode('_', $providerCode)[1];
			/** @var VoucherCodeServicesEntity $voucherCodeService */
			/** @var VoucherCodesEntity $code */
			/** @var VoucherCodeProvidersEntity $provider */
			$code = VoucherCodes::Db()->where([
				'voucher_code_provider_id' => "$providerId",
				'voucher_code_percent'     => "$percent",
			])->orderBy('', true)->limit(1)->get()->first();
			if ($code instanceof VoucherCodesEntity) {
				$codeString = $code->code;
				$usedCount = VoucherUseCodes::Db()->where(
					[
						'voucher_code_user_id' => $userId,
						'code_id_generated'    => $providerCode,
					]
				)->rowCount();
				if ($code->code_user_count == 1 && $usedCount > 0) {
					return response([
						'message' => 'userUsedBefore',
					], 400);
				}
				if ($code->code_count <= VoucherUseCodes::getAllFiltered("voucher_code", $code->code)->length()) {
					$code->delete();
				}
				VoucherUseCodes::add([
					'voucher_code'           => $codeString,
					'voucher_code_user_id'   => $userId,
					'code_id_generated'      => $providerCode,
					'voucher_code_user_date' => time(),
				]);
				return response([
					'voucherCode' => $code->code,
				]);
			}
			return response([
				'message' => 'codeNotFound',
			], 404);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
