<?php

namespace routes;

use Str;
use Api\BaseRouter;
use FwRoutingSystem\Router;

class ServicesRoute extends BaseRouter {
	public $groupPath = 'services';
	
	public function requiredHeaders() : array {
		return [];
	}
	
	public function routes(Router $router) {
		$router->get('/gender/:all', function ($name) {
			return response(['gender' => $this->getGender($name)]);
		});
		$router->get('/random', function () {
			$teams = [
				'bayern',
				'real',
				'barca',
				'paris',
				'man c',
				'man united',
				'juve',
				'atl',
			];
			return $teams[array_rand($teams)];
		});
	}
	
	private function getGender(string $name) {
		$name = $this->cleanName(str($name));
		if ($this->males()->$name) {
			return 'MALE';
		} elseif ($this->females()->$name) {
			return 'FEMALE';
		} else {
			return 'UNKNOWN';
		}
	}
	
	private function cleanName(Str $name) {
		$name = $name->toLower();
		$name = $name->replace('ي', 'ی');
		$name = $name->replace('ك', 'ک');
		$name = $name->replace('ـ', '');
		$name = $name->replace(' ', '');
		$name = $name->replace('ِ ', '');
		$name = $name->replace(' ', '');
		$name = $name->replace(' ', '');
		$name = $name->replace(' ', '');
		$name = $name->replace(' ', '');
		preg_replace('^s +|^0 - 9 +|^۰ - ۹ | [(آ - ی)(a - z)]', '', $name);
		return $name;
	}
	
	public function males() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/gender/male.json');
		return json_decode($fileData);
	}
	
	public function females() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/gender/female.json');
		return json_decode($fileData);
	}
}
