<?php

namespace routes;

use model\Startups;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;

class QrCodeRoute extends \Api\BaseRouter {
	public $groupPath = 'qr';
	
	public function routes(Router $router) {
		$router->get('/:id', $this->middleware($router), function ($id) {
			var_dump($id);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
