<?php

namespace routes;

use model\Startups;
use Api\BaseRouter;
use controller\Castes;
use controller\WorkGroups;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;
use controller\ProviderToStartup;

class ProvidersRouter extends BaseRouter {
	public $groupPath = 'providers';
	
	public function routes(Router $router) {
		$router->get("/:id", $this->middleware($router), function ($casteId) {
			$ProviderToStartup = new ProviderToStartup();
			return response($ProviderToStartup->getProviders(get_header('token'), $_GET['cityId'], $casteId));
		});
		$router->get('/single/:id', $this->middleware($router), function ($id) {
			$ProviderToStartup = new ProviderToStartup();
			return response($ProviderToStartup->single(get_header('token'), $id));
		});
		$router->get('/universal', $this->middleware($router), function () {
			$ProviderToStartup = new ProviderToStartup();
			return response($ProviderToStartup->universalProviders());
		});
		$router->get('/groups', $this->middleware($router), function () {
			$workGroups = new WorkGroups();
			return response($workGroups->allWorkgroup());
		});
		$router->get('/castes/:id', $this->middleware($router), function ($workGroupId) {
			$castes = new Castes();
			return response($castes->allCastes($workGroupId));
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
}
