<?php

namespace routes;

use fwJson\Json;
use model\Levels;
use model\Cities;
use model\Startups;
use Api\BaseRouter;
use model\Customers;
use model\Providers;
use controller\Castes;
use model\Individuals;
use model\PaymentTable;
use model\StartupUsers;
use model\ProviderLevels;
use controller\WorkGroups;
use FwRoutingSystem\Router;
use model\ProviderComments;
use model\ProviderBranches;
use controller\ContractTypes;
use model\Entity\LevelsEntity;
use model\Entity\CastesEntity;
use model\Entity\CitiesEntity;
use model\Entity\StartupsEntity;
use site\helpers\ParsianPayment;
use controller\ProviderToStartup;
use model\Entity\CustomersEntity;
use model\Entity\ProvidersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\StartupUsersEntity;
use model\Entity\ProviderLevelsEntity;
use model\Entity\ProviderBranchesEntity;
use model\Entity\ProviderToStartupEntity;

class ProvidersRoute extends BaseRouter {
	public $groupPath = 'providers';
	
	public function routes(Router $router) {
		$router->get("/:id", $this->middleware($router), function ($casteId) {
			$ProviderToStartup = new ProviderToStartup();
			$page = $_GET['page'] ?? 0;
			$limit = $_GET['limit'] ?? 12;
			$sortBy = $_GET['sortBy'] ?? 'discount';
			$sortType = $_GET['sortType'] ?? 'asc';
			[
				$count,
				$data,
			] = $ProviderToStartup->getProviders(get_header('token'), $_GET['cityId'], $casteId, $sortBy, $sortType, $page, $limit);
			return response([
				'totalCount' => $count,
				'data'       => $data,
			]);
		});
		$router->post('/rate/:id', $this->middleware($router), function ($id) {
			/** @var ProvidersEntity $provider */
			$provider = Providers::get($id);
			$startup = Startups::getByToken(get_header('token'));
			/** @var ProviderToStartupEntity $providerStartup */
			$providerStartup = \model\ProviderToStartup::getByStartup($provider->provider_id, $startup);
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			$array = [
				'mobile'                 => $mobile,
				'provider_to_startup_id' => $providerStartup->provider_to_startup_id,
			];
			$oldComment = ProviderComments::Db()->where($array)->rowCount();
			if ($oldComment == 0) {
				if ($providerStartup instanceof ProviderToStartupEntity) {
					$rate = $this->getParam('rate');
					$comment = $this->getParam('comment');
					$array['provider_comment_rating'] = $rate;
					$array['provider_comment_text'] = $comment;
					$array['provider_comment_date'] = time();
					if (ProviderComments::add($array)) {
						return response('done', 200);
					} else {
						return response('error', 400);
					}
				} else {
					return response('Provider Not Found!', 404);
				}
			} else {
				return response('User has commented before', 404);
			}
		});
		$router->get('/single/:id', $this->middleware($router), function ($id) {
			$ProviderToStartup = new ProviderToStartup();
			return response($ProviderToStartup->single(get_header('token'), $id));
		});
		$router->get('/universal', $this->middleware($router), function () {
			$ProviderToStartup = new ProviderToStartup();
			return response($ProviderToStartup->universalProviders());
		});
		$router->get('/groups', $this->middleware($router), function () {
			$workGroups = new WorkGroups();
			return response($workGroups->allWorkgroup());
		});
		$router->get('/castes/:id?', $this->middleware($router), function ($workGroupId = 0) {
			$castes = new Castes();
			return response($castes->allCastes($workGroupId));
		});
		$router->get('/castes/:id?/:id?', $this->middleware($router), function ($casteId = 0, $providerId = 0) {
			
			$startup = Startups::getByToken(get_header('token'));
			/** @var ProviderToStartupEntity $data */
			$data = \model\ProviderToStartup::get($providerId);
			/** @var ProvidersEntity $provider */
			$provider = Providers::get($data->provider_id);
			$output = \model\Castes::get($provider->caste_id)->apiFormat();
			return response($output, isset($output) ? 200 : 404);
		});
		$router->post('/pay', $this->middleware($router), function () {
			$mobile = $this->getParam('mobile', true, function ($row) {
				return str($row)->len() == 11;
			});
			$startup = Startups::getByToken(get_header('token'));
			$callback = $this->getParam('callback', true);
			$amount = $this->getParam('amount', true, function ($amount) {
				return $amount >= 5000;
			}, ['message' => 'minimum amount for payment is 5000 toman']);
			$level = $this->getParam('level', true, function ($level) use ($startup) {
				return Levels::byCodeAndStartup($level, $startup) instanceof LevelsEntity;
			});
			$providerId = $this->getParam('providerId', true, function ($providerId) use ($startup) {
				return \model\ProviderToStartup::getByStartup($providerId, $startup) instanceof ProviderToStartupEntity;
			});
			$customer = Customers::getByMobile($mobile);
			if (!($customer instanceof CustomersEntity)) {
				$customer = Customers::get(Customers::quickAddMobile($mobile));
			}
			/** @var LevelsEntity $level */
			$level = Levels::byCodeAndStartup($level, $startup);
			/** @var ProviderToStartupEntity $provider */
			$provider = \model\ProviderToStartup::getByStartup($providerId, $startup);
			$providerPercent = ($provider->to_startup_cash_discount - ($startup->startup_hub_percent + $startup->startup_percent));
			$providerPercent = $providerPercent >= 0 ? $providerPercent : 0;
			$percent = ($level->discount_percent * $providerPercent) / 100;
			$finalAmount = $amount - (($percent * $amount) / 100);
			$startupUser = StartupUsers::getByStartup($customer->customer_id, $startup);
			if ($startupUser instanceof StartupUsersEntity) {
				$startupUser->level_id = $level->level_id;
				$startupUser->save();
			} else {
				StartupUsers::edit($startupUser->startup_user_id, [
					'level_id' => $level->level_id,
				]);
			}
			$time = $this->getParam('timestamp', true, function ($timeStamp) {
				return true;
			}, ['message' => 'time is not accurate hence it can\'t be used for data saving']);
			$resNum = $this->getParam('resNum', true, function ($resNum) {
				return true;
			});
			$fromWallet = $this->getParam('fromWallet', true, function ($fromWallet) {
				return $fromWallet == 'true' || $fromWallet == 'false';
			});
			$fromWallet = $fromWallet == 'true';
			if ($fromWallet) {
				$credit = $startupUser->credit;
				if ($credit < $finalAmount) {
					return response(['message' => 'User credit is less than the desired amount'], 401);
				} else {
					$providerDiscountPercent = $provider->to_startup_cash_discount;
					$provider->credit = ($providerDiscountPercent * $amount) / 100;
					$provider->save();
					$providerPercent = ($provider->to_startup_cash_discount - ($startup->startup_hub_percent + $startup->startup_percent));
					$providerPercent = $providerPercent >= 0 ? $providerPercent : 0;
					/** @var LevelsEntity $currentLevel */
					$changes = [
					];
					for ($i = 1; $i <= $startup->referral_count; $i++) {
						if (str($startupUser->parent . '')->len() > 0) {
							$parent = StartupUsers::getByMobile($startupUser->mobile);
							if ($parent instanceof StartupUsersEntity) {
								$currentLevel = $parent->level_id;
								$currentLevel = Levels::get($currentLevel);
								$percent = ($currentLevel->discount_percent * $providerPercent) / 100;
								$finalAmount = (($percent * $amount) / 100);
								$parent->credit += $finalAmount;
								$changes[$parent->mobile] = $parent->credit;
								$parent->save();
								if (str($parent->parent . '')->len() > 0) {
									$startupUser = $parent;
								} else {
									break;
								}
							} else {
								break;
							}
						} else {
							break;
						}
					}
					$startupUser->credit -= $finalAmount;
					if ($startupUser->save()) {
						$changes[$startupUser->mobile] = $startupUser->credit;
						$resultForUser = CallAPI('post', 'https://api.negaclub.ir/changeUserCredit', $changes, ['Content-Type' => 'application/json'], true);
						CallAPI('post', 'https://api.negaclub.ir/changeProviderCredit', [
							'mobile' => $provider->getMobile(),
						], ['Content-Type' => 'application/json'], true);
						return response(NULL, 202);
					}
					return response(['message' => 'save credit failed'], 402);
				}
			} else {
				$Payment = new ParsianPayment();
				$Payment->UserModel(new Customers(), $customer);
				$Payment->initPayment(new PaymentTable());
				$Payment->Amount($finalAmount);
				$Payment->Type('provider_payment');
				$Payment->OrderData(Json::encode([
					'callback'    => $callback,
					'provider_id' => $providerId,
					'real_amount' => $amount,
					'startup_id'  => $startup->id,
					'resNum'      => $resNum,
				]));
				$url = $Payment->goToPayment();
				if (filter_var($url, FILTER_VALIDATE_URL)) {
					$output['url'] = $url;
					$status = 202;
				} else {
					$status = 401;
					$output['message'] = $url . ' - ' . $finalAmount;
				}
				return response($output, $status);
			}
		});
		$router->post('/add', $this->middleware($router), function () {
			$startup = Startups::getByToken(get_header('token'));
			$provider_manager_mobile = $this->getParam('provider_manager_mobile');
			$provider_manager_first_name = $this->getParam('provider_manager_first_name');
			$provider_manager_last_name = $this->getParam('provider_manager_last_name');
			$provider_manager_gender = $this->getParam('provider_manager_gender');
			$provider_name = $this->getParam('provider_name');
			$provider_national_code = $this->getParam('provider_national_code');
			$provider_image = $this->getParam('provider_image');
			$provider_tel = $this->getParam('provider_tel');
			$provider_number = $this->getParam('provider_number');
			$provider_start_date = $this->getParam('provider_start_date');
			$provider_end_date = $this->getParam('provider_end_date');
			$provider_discount = $this->getParam('provider_discount');
			$provider_startup_percent = $this->getParam('provider_startup_percent');
			$provider_cashback_percent = $this->getParam('provider_cashback_percent');
			$provider_id_series = $this->getParam('provider_id_series');
			$provider_id_serial = $this->getParam('provider_id_serial');
			$provider_national_card_serial = $this->getParam('provider_national_card_serial');
			$provider_want_pos = $this->getParam('provider_want_pos');
			$psp_information = $this->getParam('psp_information');
			$provider_id = $this->getParam('provider_id');
			$provider_branch_has_auth_yes_no = $this->getParam('provider_branch_has_auth_yes_no');
			$provider_branch_auth_number = $this->getParam('provider_branch_auth_number');
			$provider_branch_post_code = $this->getParam('provider_branch_post_code');
			$country_id = $this->getParam('country_id');
			$state_id = $this->getParam('state_id');
			$city_id = $this->getParam('city_id');
			$provider_branch_main_street = $this->getParam('provider_branch_main_street');
			$provider_branch_secondary_street = $this->getParam('provider_branch_secondary_street');
			$provider_branch_address_full = $this->getParam('provider_branch_address_full');
			$provider_branch_plaque = $this->getParam('provider_branch_plaque');
			$provider_branch_latitude = $this->getParam('provider_branch_latitude');
			$provider_branch_longitude = $this->getParam('provider_branch_longitude');
			$provider_branch_name = $this->getParam('provider_branch_name');
			$zipDocument = $_FILES['zipDocuments'];
			$workgroup_id = $this->getParam('workgroup_id');
			$caste_id = $this->getParam('caste_id');
			$individual = Individuals::getByMobile($provider_manager_mobile);
			if (!($individual instanceof IndividualsEntity)) {
				/** @var IndividualsEntity $individual */
				$individual = Individuals::get(Individuals::add([
					'individual_gender'     => $provider_manager_gender,
					'individual_first_name' => $provider_manager_first_name,
					'individual_last_name'  => $provider_manager_last_name,
					'individual_mobile'     => $provider_manager_mobile,
				]));
			}
			$provider = Providers::Db()->where([
				'individual_id' => $individual->individual_id,
				'workgroup_id'  => $workgroup_id,
				'caste_id'      => $caste_id,
			])->get();
			if ($provider->length() > 0) {
				$provider = $provider->first;
			} else {
				$provider = Providers::get(Providers::add([
					'provider_name'    => $provider_name,
					'provider_manager' => $individual->individual_id,
					'provider_tel'     => CorrectMobile($provider_tel),
					'workgroup_id'     => $workgroup_id,
					'caste_id'         => $caste_id,
				]));
			}
			/** @var ProvidersEntity $provider */
			$providerBranch = ProviderBranches::Db()->where([
				'provider_id' => $provider->provider_id,
			])->get();
			if ($providerBranch->length() > 0) {
				$providerBranch = $providerBranch->first;
			} else {
				/** @var CitiesEntity $city */
				$city = Cities::get($city_id);
				$providerBranch = ProviderBranches::get(ProviderBranches::add([
					'provider_branch_name'             => $provider_branch_name,
					'provider_manager'                 => $individual->individual_id,
					'country_id'                       => $country_id,
					'state_id'                         => $state_id,
					'city_id'                          => $city_id,
					'provider_branch_latitude'         => $provider_branch_latitude,
					'provider_branch_longitude'        => $provider_branch_longitude,
					'provider_branch_post_code'        => $provider_branch_post_code,
					'provider_id'                      => $provider->provider_id,
					'provider_branch_main_street'      => $provider_branch_main_street,
					'provider_branch_secondary_street' => $provider_branch_secondary_street,
					'provider_branch_address_full'     => $provider_branch_address_full,
					'provider_branch_plaque'           => $provider_branch_plaque,
					'provider_branch_auth_number'      => $provider_branch_auth_number,
					'provider_branch_has_auth_yes_no'  => $provider_branch_has_auth_yes_no,
				]));
			}
			/** @var ProviderBranchesEntity $providerBranch */
			/** @var CastesEntity $caste */
			$caste = \model\Castes::get($caste_id);
			$differencePercent = $caste->minimum_percent - $provider_discount;
			/** @var ProviderLevelsEntity $providerLevel */
			$providerLevel = ProviderLevels::Db()->custom("SELECT * FROM tblProviderLevels where startup_id = {$startup->id} ORDER BY provider_level_difference - $differencePercent LIMIT 1")->get()->first;
			$providerLevel = ProviderLevelsEntity::fromArray((array)$providerLevel);
			$toStartup = \model\ProviderToStartup::add([
				'provider_level_id'                   => $providerLevel->provider_level_id,
				'startup_id'                          => $startup->id,
				'provider_branch_id'                  => $providerBranch->provider_branch_id,
				'provider_credit'                     => 0,
				'provider_to_startup_contract_number' => $provider_number,
				'provider_to_startup_start_date'      => $provider_start_date,
				'provider_to_startup_end_date'        => $provider_end_date,
				'contracttype_id'                     => 1,
				'provider_to_startup_cash_discount'   => $provider_discount,
				'provider_startup_percent'            => $provider_startup_percent,
				'provider_cashback_percent'           => $provider_cashback_percent,
				'provider_id'                         => $provider->provider_id,
				'provider_to_startup_date'            => time(),
			]);
			/** @var ProviderToStartupEntity $toStartup */
			$toStartup = \model\ProviderToStartup::get($toStartup);
			return response($toStartup->apiFormat());
		});
		$router->get('/contract-types', $this->middleware($router), function () {
			$castes = new ContractTypes();
			return response($castes->allContractTypes());
		});
		$router->post('/get-level', $this->middleware($router), function () {
			$startup = Startups::getByToken(get_header('token'));
			$percent = $this->getParam('percent');
			$casteId = $this->getParam('casteId');
			/** @var CastesEntity $caste */
			$caste = \model\Castes::get($casteId);
			$howMuchPercentItIs = ($percent * 100) / $caste->minimum_percent;
			/** @var ProviderLevelsEntity $providerLevel */
			$providerLevel = ProviderLevels::Db()->custom("SELECT * FROM tblProviderLevels where startup_id = 40 and provider_level_difference_min <= $howMuchPercentItIs and (provider_level_difference = 0 or provider_level_difference > $howMuchPercentItIs)")->get()->first;
			if ($providerLevel != NULL) {
				$providerLevel = ProviderLevelsEntity::fromArray((array)$providerLevel);
				return response($providerLevel->apiFormat());
			} else {
				return response(['message' => "level not found"], 404);
			}
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
