<?php

namespace routes;

use PDO;
use fwJson\Json;
use model\Startups;
use model\Customers;
use model\ShopCarts;
use model\Districts;
use model\OrderShifts;
use model\PaymentTable;
use model\SendingTimes;
use model\NegaShopCities;
use FwRoutingSystem\Router;
use model\NegaShopStartups;
use model\CustomerAddresses;
use model\Entity\StartupsEntity;
use site\helpers\ParsianPayment;
use model\Entity\ProductsEntity;
use FwBase\Reports\ReportScheme;
use model\Entity\CustomersEntity;
use model\Entity\ShopCartsEntity;
use model\Entity\DistrictsEntity;
use model\Entity\DeliveriesEntity;
use model\Entity\SendingTimesEntity;
use model\Entity\NegaShopStartupsEntity;
use model\Entity\CustomerAddressesEntity;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class NegaShopRoute extends \Api\BaseRouter {
	public $groupPath = 'negashop';
	
	public function routes(Router $router) {
		$router->post('/mainStartups', $this->middleware($router), function () {
			$addressId = $this->getParam('addressId');
			/** @var CustomerAddressesEntity $address */
			$address = CustomerAddresses::get($addressId);
			if ($address instanceof CustomerAddressesEntity) {
				$startups = collect(NegaShopStartups::withStartup())->map(function ($item) use ($address) {
					return [
						'shopId'    => $item->nega_shop_startup_id,
						'startupId' => $item->startup_id,
						'name'      => $item->startup_name,
						'color'     => $item->color,
						'details'   => $item->startup_details,
						'icon'      => __IMAGES__ . 'NegaShopStartups/' . $item->negashop_startup_id,
						'logo'      => __IMAGES__ . 'Startups/' . $item->startup_logo,
						'groups'    => NegaShopStartups::groupsByNegaShop($item->nega_shop_startup_id, $address->city_id),
					];
				});
				return response($startups);
			}
			return response([]);
		});
		$router->post('/products', $this->middleware($router), function () {
			$addressId = $this->getParam('addressId');
			$generalId = str($this->getParam('generalId'))->explode('_');
			$subGroupId = $this->getParam('subGroupId',false);
			if (!$subGroupId) $subGroupId = 0;
			$startupId = $generalId[0];
			$groupId = $generalId[1];
			/** @var CustomerAddressesEntity $address */
			$address = CustomerAddresses::get($addressId);
			if ($address instanceof CustomerAddressesEntity) {
				$negashopStartup = NegaShopStartups::get($startupId);
				if ($negashopStartup instanceof NegaShopStartupsEntity) {
					$startup = Startups::get($negashopStartup->startup_id);
					if ($startup instanceof StartupsEntity) {
						$negashop = NegaShopCities::Db()->where([
							'nega_shop_startup_id' => $negashopStartup->nega_shop_startup_id,
							'city_id'              => $address->city_id,
						])->get()->first;
						[
							$productGroup,
							$subGroups,
							$products,
						] = NegaShopStartups::getGroupProducts($startupId, $groupId, $negashop->nega_shop_city_id,$subGroupId);
						return response([
							'productGroup' => $productGroup,
							'subGroups'    => $subGroups,
							'products'     => $products,
							'startup'      => $startup->apiFormat(),
							'groups'       => NegaShopStartups::groupsByNegaShop($negashop->nega_shop_startup_id, $address->city_id),
						]);
					}
				}
				return response([]);
			}
			return response([]);
		});
		$router->get('/addressList/:id', $this->middleware($router), function ($mobile) {
			$customer = Customers::getByMobile($mobile);
			if ($customer instanceof CustomersEntity) {
				$addressList = CustomerAddresses::getAllFiltered('customer_id', $customer->customer_id)->map(function (CustomerAddressesEntity $customer_address) {
					return $customer_address->apiFormat();
				});
				return response($addressList->all());
			}
			return response("Failed To Fetch Addresses");
		});
		$this->cart($router);
		$router->post('/sendingTimes', $this->middleware($router), function () {
			$list = json_decode($this->getParam('productIds'));
			$mobile = $this->getParam('mobile');
			$startupId = $this->getParam('startupId');
			$addressId = $this->getParam('addressId');
			/** @var CustomerAddressesEntity $address */
			$address = CustomerAddresses::get($addressId);
			if ($address instanceof CustomerAddressesEntity) {
				$startup = Startups::getByHashedId($startupId);
				$startupId = $startup->id;
				$negaShop = NegaShopStartups::getOneFiltered('startup_id', $startupId);
				if ($negaShop instanceof NegaShopStartupsEntity) {
					$shopId = $negaShop->nega_shop_startup_id;
					$negashop = NegaShopCities::Db()->where([
						'nega_shop_startup_id' => $shopId,
						'city_id'              => $address->city_id,
					])->get()->first;
					$result = NegaShopStartups::getSendingTimes($startupId, $list, $negashop->nega_shop_city_id);
					return response($result);
				} else {
					return response("Startup not found");
				}
			}
			return response("Address not found");
		});
		$router->post('/paymentTypes', $this->middleware($router), function () {
			$list = json_decode($this->getParam('productIds'));
			$mobile = $this->getParam('mobile');
			$startupId = $this->getParam('startupId');
			$addressId = $this->getParam('addressId');
			/** @var CustomerAddressesEntity $address */
			$address = CustomerAddresses::get($addressId);
			if ($address instanceof CustomerAddressesEntity) {
				$startup = Startups::getByHashedId($startupId);
				$startupId = $startup->id;
				$negaShop = NegaShopStartups::getOneFiltered('startup_id', $startupId);
				if ($negaShop instanceof NegaShopStartupsEntity) {
					$shopId = $negaShop->nega_shop_startup_id;
					$negashop = NegaShopCities::Db()->where([
						'nega_shop_startup_id' => $shopId,
						'city_id'              => $address->city_id,
					])->get()->first;
					$paymentTypes = NegaShopStartups::getPaymentTypes($startupId, $list, $negashop->nega_shop_city_id);
					$prices = NegaShopStartups::getPrices($startupId, $list);
					return response(['paymentTypes' => $paymentTypes, 'prices' => $prices,]);
				} else {
					return response("Startup not found");
				}
			}
			return response("Address not found");
		});
		$router->post('/submitOrder', $this->middleware($router), function () {
			$addressId = $this->getParam('addressId');
			$startupId = $this->getParam('startupId');
			$mobile = $this->getParam('mobile');
			$sendingTimes = $this->getParam('sendingTimes');
			$paymentTypeId = $this->getParam('paymentTypeId');
			$discountCode = $this->getParam('discountCode', false);
			$list = json_decode($this->getParam('productIds'));
			$discount = 0;
			/** @var CustomerAddressesEntity $address */
			$address = CustomerAddresses::get($addressId);
			$output = [
				'status' => false,
				'type'   => "url",
			];
			$customer = Customers::getByMobile($mobile);
			if ($customer instanceof CustomersEntity) {
				if ($address instanceof CustomerAddressesEntity) {
					$startup = Startups::getByHashedId($startupId);
					$startupId = $startup->id;
					$negaShop = NegaShopStartups::getOneFiltered('startup_id', $startupId);
					if ($negaShop instanceof NegaShopStartupsEntity) {
						$shopId = $negaShop->nega_shop_startup_id;
						$prices = NegaShopStartups::getPrices($shopId, $list);
						switch ($shopId) {
							case 1:
							default:
								switch ($paymentTypeId) {
									case 3:
									default:
										$Payment = new ParsianPayment();
										$Payment->initPayment(new PaymentTable());
										$Payment->UserModel(new Customers(), $customer);
										$Payment->Amount($prices['totalPrice']);
										$Payment->Type('startup_payment_for_order');
										$Payment->OrderData(Json::encode([
											'startup'      => $startup->apiFormat(),
											'mobile'       => $mobile,
											'list'         => $list,
											'sendingTimes' => $sendingTimes,
											'addressId'    => $addressId,
										]));
										$url = $Payment->goToPayment('https://pay.negahub.com/v1/callback');
										if (filter_var($url, FILTER_VALIDATE_URL)) {
											$output['status'] = true;
											$output['url'] = $url;
										} else {
											$output['message'] = $url;
										}
										return response($output);
									case 8:
										$conn = NegaShopStartups::getNoonConn();
										$Orders = Db::table('tblOrders')->setNewConn($conn);
										$Customers = Db::table('tblCustomers')->setNewConn($conn);
										$SendingTimes = Db::table('tblSendingTimes')->setNewConn($conn);
										$OrderShifts = Db::table('tblOrderShifts')->setNewConn($conn);
										$Products = Db::table('tblProducts')->setNewConn($conn);
										$CustomerAddresses = Db::table('tblCustomerAddresses')->setNewConn($conn);
										$Districts = Db::table('tblDistricts')->setNewConn($conn);
										$Cities = Db::table('tblCities')->setNewConn($conn);
										/** @var CustomerAddressesEntity $address */
										$address = \model\CustomerAddresses::get($addressId);
										if ($Customers->where('customer_mobile', $customer->mobile)->get()->length() > 0) {
											$Customers->reset();
											$customerData = $Customers->where('customer_mobile', $customer->mobile)->get()->first;
											$customer->mobile = $customerData->customer_mobile;
											$customer->customer_id = $customerData->customer_id;
										} else {
											$Customers->reset();
											$insert = $Customers->insert([
												'customer_mobile'     => $mobile,
												'customer_first_name' => $customer->first_name,
												'customer_last_name'  => $customer->last_name,
											]);
											if ($insert) {
												$customer->customer_id = $insert;
											}
										}
										$CustomerAddresses->reset();
										if ($CustomerAddresses->where([
												'customer_id'                => $customer->customer_id,
												'customer_address_latitude'  => $address->customer_address_latitude,
												'customer_address_longitude' => $address->customer_address_longitude,
											])->get()->length() > 0) {
											$CustomerAddresses->reset();
											$address = $CustomerAddresses->where([
												'customer_id'                => $customer->customer_id,
												'customer_address_latitude'  => $address->customer_address_latitude,
												'customer_address_longitude' => $address->customer_address_longitude,
											])->get();
											$addressId = $address->customer_address_id;
										} else {
											/** @var DistrictsEntity $district */
											$district = Districts::get($address->district_id);
											$districtName = $district->name;
											$Districts->reset();
											if ($Districts->where('district_name', 'like', "%$districtName%")->get()->length() == 0) {
												
												$negashop = NegaShopCities::Db()->where([
													'nega_shop_startup_id' => $shopId,
													'city_id'              => $address->city_id,
												])->get()->first;
												$cityId = $negashop->nega_shop_city_id;
												$city = $Cities->where('city_id', $cityId)->get()->first;
												$districtId = $Districts->insert([
													'district_name'    => $districtName,
													'state_id'         => $city->state_id,
													'city_id'          => $cityId,
													'district_polygon' => $district->district_polygon,
												]);
											} else {
												$Districts->reset();
												$districtId = $Districts->where('district_name', 'like', "%$districtName%")->get()->first->district_id;
											}
											$CustomerAddresses->reset();
											$addressId = $CustomerAddresses->insert([
												'customer_address_name'      => $address->customer_address_title,
												'customer_address_full'      => $address->customer_address_full,
												'district_id'                => $districtId,
												'customer_id'                => $customer->customer_id,
												'customer_address_latitude'  => $address->customer_address_latitude,
												'customer_address_longitude' => $address->customer_address_longitude,
											]);
										}
										$Orders->reset();
										$id = $Orders->insert([
											'customer_id'                => $customer->customer_id,
											'customer_address_id'        => $addressId,
											'order_delivery_type_yes_no' => 1,
											'user_id'                    => -1,
											'order_details'              => '',
											'send_price'                 => $prices['sendPrice'],
											'package_price'              => $prices['packagePrice'],
											'products_price'             => $prices['productsPrice'],
											'total_price'                => $prices['totalPrice'],
											'payment_price'              => $prices['totalPrice'] - $discount,
											'order_payment_type'         => $paymentTypeId,
											'coupon_code'                => $discountCode,
											'payment_status'             => ($paymentTypeId == '3' ? '-1' : '0'),
											'order_from'                 => 1,
										]);
										if ($id) {
											$Orders->reset();
											$id = $Orders->orderBy('order_id', true)->limit(1)->get()->first->order_id;
										}
										if ($id > 0) {
											$i = 0;
											$ids = [];
											$order_products = [];
											$Products->reset();
											$products = $Products->whereIn('product_id', $list)->get();
											$sendingTimes = json_decode($sendingTimes, true);
											foreach ($sendingTimes as $groupId => $shiftId) {
												$order_products[$groupId] = [
													'sending_time' => $shiftId[1],
													'products'     => [],
													'packagePrice' => 0,
													'sendPrice'    => 0,
													'order_date'   => $shiftId[0],
												];
												foreach ($products as $product) {
													if ($product->product_group_id == $groupId) {
														if (!isset($order_products[$groupId]['products'][$product->product_id])){
															$order_products[$groupId]['products'][$product->product_id] = [
																'price'   => $product->product_price,
																'isToday' => $shiftId[0] == 'today' ? 1 : 2,
																'count'   => 0,
															];
														}
														$order_products[$groupId]['products'][$product->product_id]['count'] += array_count_values_of($product->product_id, $list) * $product->product_factor;
														
													}
												}
											}
											foreach ($order_products as $product_group_id => $data) {
												if (is_array($data) and $data['products']) {
													$i++;
													$shift_id = $data['sending_time'];
													$SendingTimes->reset();
													$shift = $SendingTimes->where('sending_time_id', $shift_id)->get()->first;
													$arr = [
														'delivery_id'     => NegaShopStartups::chooseDeliveryForOrder($address->district_id, $shift_id, $data['order_date'], $conn),
														'order_date'      => $data['order_date'],
														'order_products'  => NegaShopStartups::productsToOrderShiftInfo($address->district_id, $address->customer_address_latitude, $address->customer_address_longitude, $data['products'], $conn),
														'sending_time_id' => $shift_id,
														'time_start'      => $shift->sending_time_start,
														'time_end'        => $shift->sending_time_end,
														'send_price'      => $data['sendPrice'],
														'package_price'   => $data['packagePrice'],
														'products_price'  => NegaShopStartups::sumProducts($data['products'], $conn),
														'coupon_code'     => $discountCode,
													];
													$arr['total_price'] = $arr['send_price'] + $arr['products_price'];
													$arr['order_id'] = $id;
													$ids[] = $OrderShifts->insert($arr);
												}
											}
											if (count($ids) == $i) {
												$output['status'] = true;
												$output['type'] = 'cash';
												$output['id'] = $id;
											}
											break;
										} else {
											$Orders->where('order_id', $id)->delete();
										}
								}
						}
					}
				}
				return response($output);
			}
		});
	}
	
	private function cart(Router $router) {
		$router->group('/cart', function (Router $router) {
			$router->post('/add', function () {
				$mobile = $this->getParam('mobile');
				// product id
				$productId = $this->getParam('id');
				// startup id
				$startupId = $this->getParam('startupId');
				$cart = ShopCarts::getByMobile($mobile);
				$res = false;
				if ($cart instanceof ShopCartsEntity) {
					$json = json_decode($cart->cart_data, true);
					if ($json) {
						if (isset($json[$startupId])) {
							if (isset($json[$startupId][$productId])) {
								$json[$startupId][$productId] += 1;
								$res = ShopCarts::edit($cart->shop_cart_id, [
									'shop_cart_mobile' => $mobile,
									'shop_cart_data'   => json_encode($json),
								]);
							} else {
								$json[$startupId][$productId] = 0;
								$res = ShopCarts::edit($cart->shop_cart_id, [
									'shop_cart_mobile' => $mobile,
									'shop_cart_data'   => json_encode($json),
								]);
							}
						} else {
							$json[$startupId] = [
								$productId => 1,
							];
							$res = ShopCarts::edit($cart->shop_cart_id, [
								'shop_cart_mobile' => $mobile,
								'shop_cart_data'   => json_encode($json),
							]);
						}
					} else {
						$res = ShopCarts::edit($cart->shop_cart_id, [
							'shop_cart_mobile' => $mobile,
							'shop_cart_data'   => [
								$startupId => [
									$productId => 1,
								],
							],
						]);
					}
				} else {
					$res = ShopCarts::add([
						'shop_cart_mobile' => $mobile,
						'shop_cart_data'   => [
							$startupId => [
								$productId => 1,
							],
						],
					]);
				}
				return response($res ? 'ok' : 'error', $res ? 200 : 400);
			});
			$router->post('/remove', function () {
				$mobile = $this->getParam('mobile');
				// product id
				$productId = $this->getParam('id');
				// startup id
				$startupId = $this->getParam('startupId');
				$cart = ShopCarts::getByMobile($mobile);
				$res = false;
				if ($cart instanceof ShopCartsEntity) {
					$json = json_decode($cart->cart_data, true);
					if ($json) {
						if (isset($json[$startupId])) {
							if (isset($json[$startupId][$productId]) and $json[$startupId][$productId] > 0) {
								$json[$startupId][$productId] -= 1;
								$res = ShopCarts::edit($cart->shop_cart_id, [
									'shop_cart_mobile' => $mobile,
									'shop_cart_data'   => json_encode($json),
								]);
							} else {
								unset($json[$startupId][$productId]);
								$res = ShopCarts::edit($cart->shop_cart_id, [
									'shop_cart_mobile' => $mobile,
									'shop_cart_data'   => json_encode($json),
								]);
							}
						}
					}
				}
				return response($res ? 'ok' : 'error', $res ? 200 : 400);
			});
		});
	}
	

	
	public function requiredHeaders() : array {
		return [];
	}
}
