<?php

namespace routes;

use Api\BaseRouter;
use model\Startups;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;

class InsuranceRoute extends BaseRouter {
	public $groupPath = 'insurance';
	
	public function routes(Router $router) {
		$router->group('/basic-third-party-data', function (Router $router) {
			$fileData = $this->getBaseThirdPartyData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
			$this->createRoutesForBasicData($router, $fileData);
			$router->get('brands', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Brands)->map(function ($item) {
					return [
						'id'         => $item->Id,
						'title'      => $item->Title,
						'categories' => $item->VehicleCategorieIds,
					];
				}));
			});
			$router->get('vehicle-categories', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->VehicleCategories)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('using-types', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->UsingTypes)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('/car-model/:id', $this->middleware($router), function ($id) {
				$token = 'da4aa2f8-70d9-4d56-b577-3162dfae2c0f';
				$res = CallAPI('get', "https://restcore.bimeh.com/v1/insurance/third-party/car-model/$id", [], ['business-token' => $token]);
				return response(json_decode($res)->Models);
			});
		});
		$router->group('/basic-motor-data', function (Router $router) {
			$fileData = $this->getBaseMotorData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
			$this->createRoutesForBasicData($router, $fileData);
			$router->get('motor-types', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->MotorTypes)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
		});
		$router->group('/basic-car-body-data', function (Router $router) {
			$fileData = $this->getCarBodyData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
			$router->get('brands', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Brands)->map(function ($item) {
					return [
						'id'         => $item->Id,
						'title'      => $item->Title,
						'categories' => $item->VehicleCategorieIds,
					];
				}));
			});
			$router->get('using-types', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->UsingTypes)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('/car-model/:id', $this->middleware($router), function ($id) {
				$token = 'da4aa2f8-70d9-4d56-b577-3162dfae2c0f';
				$res = CallAPI('get', "https://restcore.bimeh.com/v1/insurance/car-body/car-model/$id", [], ['business-token' => $token]);
				return response(json_decode($res)->Models);
			});
			$router->get('third-party-discounts', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->ThirdPartyDiscounts)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('companies', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Companies)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
						'logo'  => $item->LogoUrl,
					];
				}));
			});
			$router->get('production-years', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->ProductionYears)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('car-body-no-damage-years', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->CarBodyNoDamageYears)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('coverages', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Coverages)->map(function ($item) {
					return [
						'id'          => $item->Id,
						'title'       => $item->Title,
						'description' => $item->Description,
					];
				}));
			});
			$router->get('banks', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Banks)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
		});
		$router->group('/basic-travel-data', function (Router $router) {
			$fileData = $this->getTravelData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
			$router->get('durations', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Durations)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('countries', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Countries)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('genders', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->Genders)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
			$router->get('visaTypes', $this->middleware($router), function () use ($fileData) {
				return response(collect($fileData->VisaTypes)->map(function ($item) {
					return [
						'id'    => $item->Id,
						'title' => $item->Title,
					];
				}));
			});
		});
		$router->group('/basic-fire-data', function (Router $router) {
			$fileData = $this->getFireData();
			
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
		});
		$router->group('/basic-travel-plus-data', function (Router $router) {
			$fileData = $this->getTravelPlusData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
		});
		$router->group('/basic-health-data', function (Router $router) {
			$fileData = $this->getHealthData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
			
		});
		$router->group('/basic-corona-data', function (Router $router) {
			$fileData = $this->getCoronaData();
			$router->get('/', $this->middleware($router), function () use ($fileData) {
				return response($fileData);
			});
		});
	}
	
	private function getBaseThirdPartyData() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicThirdPartyData.json');
		return json_decode($fileData);
	}
	
	private function createRoutesForBasicData(Router $router, $fileData) {
		$router->get('coverage-types', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->CoverageTypes)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('third-party-discounts', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->ThirdPartyDiscounts)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('driver-discounts', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->DriverDiscounts)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('life-losses', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->LifeLosses)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('property-losses', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->PropertyLosses)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('driver-losses', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->DriverLosses)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('companies', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->Companies)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
					'logo'  => $item->LogoUrl,
				];
			}));
		});
		$router->get('production-years', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->ProductionYears)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('durations', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->Durations)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
		$router->get('insurance-statuses', $this->middleware($router), function () use ($fileData) {
			return response(collect($fileData->InsuranceStatuses)->map(function ($item) {
				return [
					'id'    => $item->Id,
					'title' => $item->Title,
				];
			}));
		});
	}
	
	private function getBaseMotorData() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicMotorData.json');
		return json_decode($fileData);
	}
	
	private function getCarBodyData() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicCarBodyData.json');
		return json_decode($fileData);
	}
	
	private function getTravelData() {
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicTravelData.json');
		return json_decode($fileData);
	}
	
	private function getFireData() {
		
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicFireData.json');
		return json_decode($fileData);
	}
	
	private function getTravelPlusData() {
		
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicTravelPlusData.json');
		return json_decode($fileData);
	}
	
	private function getHealthData() {
		
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicHealthData.json');
		return json_decode($fileData);
	}
	
	private function getCoronaData() {
		
		$fileData = file_get_contents(__SOURCE__ . 'dist/data/insurance/basicCoronaData.json');
		return json_decode($fileData);
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
