<?php

namespace routes;

use FwConfig;
use model\Levels;
use model\Startups;
use Api\BaseRouter;
use FwRoutingSystem\Router;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;

class HotelRoute extends BaseRouter {
	public $groupPath = 'hotels';
	
	public function routes(Router $router) {
		$router->get('/regions', $this->middleware($router), function () {
			$token = FwConfig::FlightToken();
			$result = json_decode(CallAPI('post', "http://api.hiholiday.ir/V4/Accommodation/Regions/$token"));
			if ($result->Regions) {
				return response([
					'regions' => $result->Regions,
				]);
			}
			return response([
				'regions' => [],
			]);
		});
		$router->post('/', $this->middleware($router), function () {
			$destination = $this->getParam('destination');
			$dates = $this->getParam('dates');
			$level = $this->getParam('level');
			/** @var LevelsEntity $level */
			$level = Levels::get($level);
			$startDate = explode(',', $dates)[0];
			$endDate = explode(',', $dates)[1];
			$token = FwConfig::FlightToken();
			$result = json_decode(CallAPI('post', "http://api.hiholiday.ir/V4/Accommodation/Search/$token", [
				'Adult'        => [1],
				'Child'        => [0],
				'RegionId'     => $destination,
				'ChildAge'     => [0],
				'CheckinDate'  => $startDate,
				'CheckoutDate' => $endDate,
			]));
			if ($result->Accommodations) {
				return response([
					'accommodations' => collect($result->Accommodations)->map(function ($item) use ($level) {
						return $item;
					}),
				]);
			}
			return response([
				'accommodations' => [],
			]);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
}
