<?php

namespace routes;

use FwConfig;
use model\Startups;
use Api\BaseRouter;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;

class FlightRoute extends BaseRouter {
	public $groupPath = 'flights';
	
	public function routes(Router $router) {
		$router->get('/airports', $this->middleware($router), function () {
			$token = FwConfig::FlightToken();
			$api = CallAPI('get', "http://api.hiholiday.ir/v4/region/airport/$token");
			return response([
				'airports' => collect(json_decode($api, true)['Airports'])->map(function ($item) {
					return [
						'typeId'   => $item['RegionTypeID'],
						'enName'   => $item['RegionName'],
						'faName'   => $item['FaRegionName'],
						'longName' => $item['RegionNameLong'],
						'code'     => $item['Code'],
						'enParent' => $item['ParentRegionName'],
						'faParent' => $item['FaParentRegionName'],
					];
				}),
			]);
		});
		$router->post('/departures', $this->middleware($router), function () {
			$origin = $this->getParam('origin');
			$destination = $this->getParam('destination');
			$date = $this->getParam('date');
			$count = $this->getParam('count');
			$token = FwConfig::FlightToken();
			$page = $this->getParam('page');
			$result = json_decode(CallAPI('get', "http://api.hiholiday.ir/V4/Flight/OneWay/$token/$origin/$destination/$date/$count/10/$page"));
			if (!$result->DepartureFlights) {
				return response(['message' => 'no flight was found'], 404);
			}
			return response($result->DepartureFlights);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
}
