<?php

namespace routes;

use CrudService;
use model\Startups;
use ControllerScheme;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;

class CrudRoute extends \Api\BaseRouter {
	public $groupPath = 'crud';
	
	public function routes(Router $router) {
		$router->any('/:string/:string/:id?', function ($controller, $type, $id = 0) {
			$controller = "\controller\\$controller";
			if (class_exists($controller)) {
				$controller = new $controller();
				/** @var ControllerScheme $controller */
				if ($controller instanceof CrudService) {
					switch ($type) {
						case "list":
							if (!$controller->canReadAll()) {
								return response(['message' => 'this controller is unReadable'], 400);
							}
							if ($controller->onReadAll()) {
								return $controller->onReadAll()();
							}
							return response($controller->model()::getAll());
						case "filter":
							if (!$controller->canReadAll()) {
								return response(['message' => 'this controller is unReadable'], 400);
							}
							
							$filterField = $this->getParam('filterField');
							$filterValue = $this->getParam('filterValue');
							if ($controller->onReadAllFiltered($filterField,$filterValue)) {
								return $controller->onReadAllFiltered($filterField,$filterValue)();
							}
							return response($controller->model()::getAllFiltered("$filterField","$filterValue"));
						case "one":
							if ($id <= 0) {
								return response(['message' => 'id is not valid'], 400);
							}
							if (!$controller->canReadOne()) {
								return response(['message' => 'this controller is unReadable'], 400);
							}
							if ($controller->onReadOne($id)) {
								return $controller->onReadOne($id)();
							}
							return response($controller->model()::get($id));
						case "delete":
							if ($id <= 0) {
								return response(['message' => 'id is not valid'], 400);
							}
							if (!$controller->canDelete()) {
								return response(['message' => 'this controller is unDeleteAble'], 400);
							}
							return response($controller->model()::delete($id));
						case "update":
							if ($id <= 0) {
								return response(['message' => 'id is not valid'], 400);
							}
							if (!$controller->canUpdate()) {
								return response(['message' => 'this controller is unUpdateAble'], 400);
							}
							break;
						case "create":
							if (!$controller->canCreate()) {
								return response(['message' => 'this controller is unCreateAble'], 400);
							}
							break;
						default:
							return response(['message' => "method $type is not authorized"], 403);
					}
				} else {
					return response(['message' => 'this controller is not in crud service'], 403);
				}
			} else {
				return response(['message' => 'controller not found'], 404);
			}
			return response(['message' => 'controller not found'], 404);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token'       => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
			'crud-access' => function ($token) {
				return [
					'isCustom' => false,
					'validate' => $token == \FwConfig::CrudAccess(),
				];
			},
		];
	}
	
}
