<?php

namespace routes;

use FwConfig;
use model\Banks;
use model\Startups;
use model\Customers;
use model\LatestNews;
use controller\Levels;
use model\Individuals;
use model\CreditCards;
use model\StartupUsers;
use FwRoutingSystem\Router;
use model\Entity\BanksEntity;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;
use model\Entity\CustomersEntity;
use model\PaymentServiceProviders;
use model\Entity\LatestNewsEntity;
use model\Entity\IndividualsEntity;
use model\Entity\CreditCardsEntity;
use model\Entity\StartupUsersEntity;
use model\Entity\CasteGroupToStartupEntity;
use model\Entity\PaymentServiceProvidersEntity;

class ClubRoute extends \Api\BaseRouter {
	public $groupPath = 'club';
	
	public function routes(Router $router) {
		$router->get('/levels', $this->middleware($router), function () {
			$level = new Levels();
			$token = get_header('token');
			$startup = Startups::getByToken($token);
			$levels = $level->model()::getActiveLevelsForStartup($startup->id);
			return response($levels);
		});
		$router->get('/customer-level/:id', $this->middleware($router), function ($mobile) {
			
			$startupUser = StartupUsers::getByMobile($mobile);
			if ($startupUser instanceof StartupUsersEntity) {
				$level_id = $startupUser->level_id;
				$level = \model\Levels::get($level_id);
				if (!($level instanceof LevelsEntity)) {
					$level = \model\Levels::Db()->limit(1)->orderBy('level_id', false)->get()->first;
				}
				return response([
					'level' => $level->apiFormat(),
					'card'  => [
						'number' => '---- ---- ---- ----',
						'cvv2'   => '448',
					],
				]);
			}
			return response(['user not found'], 404);
		});
		$router->post('/levels', $this->middleware($router), function () {
			$token = get_header('token');
			$startup = Startups::getByToken($token);
			$title = $this->getParam('title');
			$discount_percent = $this->getParam('discountPercent');
			$credit_return_percent = $this->getParam('cashbackPercent');
			$min_score_join = $this->getParam('minScoreToJoin');
			$unit_score_to_credit = $this->getParam('scoreToCredit');
			$unit_credit = $this->getParam('unitCredit');
			$card_issuance = $this->getParam('isCardIssued');
			$description = $this->getParam('description');
			$register_site = $this->getParam('webSiteRegisterScore');
			$login_once_day = $this->getParam('loginPerDayScore');
			$basic_profile_information = $this->getParam('baseProfileInfoScore');
			$additional_information = $this->getParam('additionalInfoScore');
			$score_buy = $this->getParam('purchaseScore');
			$score_buy_amount = $this->getParam('purchasePerTomanScore');
			$introduc_newuser = $this->getParam('referScore');
			$record_comment = $this->getParam('commentScore');
			$record_score = $this->getParam('rateScore');
			$score_wallet = $this->getParam('chargeWalletScore');
			$min_score = $this->getParam('minScore');
			$min_credit = $this->getParam('minCredit');
			$startup_id = $startup->id;
			$level = \model\Levels::add([
				'level_title'                     => $title,
				'level_discount_percent'          => $discount_percent,
				'level_credit_return_percent'     => $credit_return_percent,
				'level_min_score_join'            => $min_score_join,
				'level_unit_score_to_credit'      => $unit_score_to_credit,
				'level_unit_credit'               => $unit_credit,
				'level_card_issuance'             => $card_issuance,
				'level_description'               => $description,
				'level_register_site'             => $register_site,
				'level_login_once_day'            => $login_once_day,
				'level_basic_profile_information' => $basic_profile_information,
				'level_additional_information'    => $additional_information,
				'level_score_buy'                 => $score_buy,
				'level_score_buy_amount'          => $score_buy_amount,
				'level_introduc_newuser'          => $introduc_newuser,
				'level_record_comment'            => $record_comment,
				'level_record_score'              => $record_score,
				'level_score_wallet'              => $score_wallet,
				'level_min_score'                 => $min_score,
				'level_min_credit'                => $min_credit,
				'startup_id'                      => $startup_id,
			]);
			if ($level > 0) {
				return response(\model\Levels::get($level)->apiFormat(), 202);
			}
			return response(['message' => 'An Error occurred'], 400);
		});
		$router->post('/register', $this->middleware($router), function () {
			$token = get_header('token');
			$startup = Startups::getByToken($token);
			// params
			$customer_first_name = $this->getParam('firstName');
			$customer_last_name = $this->getParam('lastName');
			$gender = $this->getParam('gender');
			$parentMobile = $this->getParam('parentMobile', false, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			$nationalCode = $this->getParam('nationalCode', false, function ($code) {
				if (!preg_match('/^[0-9]{10}$/', $code))
					return false;
				for ($i = 0; $i < 10; $i++)
					if (preg_match('/^' . $i . '{10}$/', $code))
						return false;
				for ($i = 0, $sum = 0; $i < 9; $i++)
					$sum += ((10 - $i) * intval(substr($code, $i, 1)));
				$ret = $sum % 11;
				$parity = intval(substr($code, 9, 1));
				if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
					return true;
				return false;
			});
			$father_name = $this->getParam('fatherName', false);
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			$level = \model\Levels::findOrUse($this->getParam('level'), $startup);
			$individual = Individuals::getByMobile($mobile);
			/** @var IndividualsEntity $individual */
			if (!($individual instanceof IndividualsEntity)) {
				$newId = Individuals::add([
					'individual_first_name' => $customer_first_name,
					'individual_last_name'  => $customer_last_name,
					'individual_gender'     => $gender,
					'individual_mobile'     => $mobile,
				]);
				if (!$newId) {
					return response(['message' => 'user could not be added', 400]);
				}
				$individual = Individuals::get($newId);
				$customer = Customers::add([
					'level_id'            => $level,
					'customer_first_name' => $customer_first_name,
					'customer_last_name'  => $customer_last_name,
					'customer_mobile'     => $mobile,
					'customer_status'     => 1,
					'individual_id'       => $individual->individual_id,
					//					'customer_national_code' => "$nationalCode",
					//					'customer_father_name'   => "$father_name",
				]);
				if (!$customer) {
					Individuals::delete($individual->individual_id);
					return response(['message' => 'user could not be added', 400]);
				}
				/** @var CustomersEntity $customer */
				$customer = Customers::get($customer);
				$startupUser = StartupUsers::add([
					'startup_id'          => $startup->id,
					'customer_id'         => $customer->customer_id,
					'startup_user_mobile' => $mobile,
					'startup_user_active' => 1,
				]);
				/** @var StartupUsersEntity $startupUser */
				$startupUser = StartupUsers::get($startupUser);
			} else {
				/** @var CustomersEntity $customer */
				$customer = Customers::getByIndividual($individual->individual_id);
				if (!($customer instanceof CustomersEntity)) {
					$customer = Customers::add([
						'level_id'            => $level,
						'customer_first_name' => $customer_first_name,
						'customer_last_name'  => $customer_last_name,
						'customer_mobile'     => $mobile,
						'customer_status'     => 1,
						'individual_id'       => $individual->individual_id,
						//						'customer_national_code' => "$nationalCode",
						//						'customer_father_name'   => "$father_name",
					]);
					if (!$customer) {
						Individuals::delete($individual->individual_id);
						return response(['message' => 'user could not be added', 400]);
					}
					$customer = Customers::get($customer);
					/** @var StartupUsers $startupUser */
					$startupUser = StartupUsers::getOneFiltered('customer_id', $customer->customer_id);
					if (!($startupUser instanceof StartupUsersEntity)) {
						$startupUser = StartupUsers::add([
							'startup_id'          => $startup->id,
							'customer_id'         => $customer->customer_id,
							'startup_user_mobile' => $mobile,
							'startup_user_active' => 1,
							'startup_user_credit' => 0,
							'startup_user_score'  => 0,
						]);
						/** @var StartupUsersEntity $startupUser */
						$startupUser = StartupUsers::get($startupUser);
					}
				} else {
					$startupUser = StartupUsers::getOneFiltered('customer_id', $customer->customer_id);
					if (!($startupUser instanceof StartupUsersEntity)) {
						$startupUser = StartupUsers::add([
							'startup_id'          => $startup->id,
							'customer_id'         => $customer->customer_id,
							'startup_user_mobile' => $mobile,
							'startup_user_active' => 1,
							'startup_user_credit' => 0,
							'startup_user_parent' => $parentMobile,
							'startup_user_score'  => 0,
						]);
						/** @var StartupUsersEntity $startupUser */
						$startupUser = StartupUsers::get($startupUser);
					}
				}
			}
			if ($customer instanceof CustomersEntity and $individual instanceof IndividualsEntity) {
				if ($startupUser instanceof StartupUsersEntity) {
					
					return response(['message' => 'successful register'], 201);
				}
				return response(['message' => 'failed to add to startup'], 402);
			} else {
				return response(['message' => 'An error occurred, contact system admin'], 401);
			}
		});
		$router->post('/availableClubs', function () {
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			$customer = Customers::getByMobile($mobile);
			if ($customer instanceof CustomersEntity) {
				$startups = Startups::getAllActives();
				$userAndStartup = [];
				/** @var StartupsEntity $startup */
				foreach ($startups as $startup) {
					$user = StartupUsers::Db()->where([
						'startup_id'          => "$startup->id",
						'startup_user_mobile' => "$mobile",
					])->get()->first;
					$arr = [
						'club'         => $startup->apiFormat(),
						'user'         => NULL,
						'isRegistered' => false,
					];
					if ($user instanceof StartupUsersEntity) {
						$arr['isRegistered'] = true;
						$arr['user'] = $user->apiFormat();
					}
					$userAndStartup[] = $arr;
				}
				return response($userAndStartup, 200);
			} else {
				return response(['message' => 'User not found'], 404);
			}
		});
		$router->get('/caste-groups', $this->middleware($router), function () {
			$startup = Startups::getByToken(get_header('token'));
			return response(\model\CasteGroupToStartup::getAllFiltered('startup_id', $startup->id)->map(function (CasteGroupToStartupEntity $caste_group_to_startup) {
				return $caste_group_to_startup->apiFormat();
			}));
		});
		$router->get('/caste-groups/:string', $this->middleware($router), function ($key) {
			$startup = Startups::getByToken(get_header('token'));
			$casteGroup = \model\CasteGroupToStartup::getOneFiltered('caste_group_to_startup_key', $key);
			if ($casteGroup instanceof CasteGroupToStartupEntity) {
				if ($casteGroup->startup_id == $startup->id) {
					return response($casteGroup->apiFormat());
				} else {
					return response(['message' => 'Unauthorized caste group for startup'], 403);
				}
			}
			return response(['message' => 'Caste group not found'], 404);
		});
		$router->post('/setNationalCode', $this->middleware($router), function () {
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			$nationalCode = $this->getParam('nationalCode', true, function ($code) {
				if (!preg_match('/^[0-9]{10}$/', $code))
					return false;
				for ($i = 0; $i < 10; $i++)
					if (preg_match('/^' . $i . '{10}$/', $code))
						return false;
				for ($i = 0, $sum = 0; $i < 9; $i++)
					$sum += ((10 - $i) * intval(substr($code, $i, 1)));
				$ret = $sum % 11;
				$parity = intval(substr($code, 9, 1));
				if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
					return true;
				return false;
			});
			/** @var CustomersEntity $customer */
			$customer = Customers::getByMobile($mobile);
			$customer->national_code = $nationalCode;
			$customer->save();
			$res1 = CallAPI('post', 'https://saheam.ir/webapi/clubservices/v2/AddOrUpdateMember', [
				"NationalCode" => "$nationalCode",
				"Name"         => $customer->first_name,
				"Family"       => $customer->last_name,
				"MobileNo"     => "$mobile",
			], [
				'Authorization' => 'Basic ' . base64_encode(FwConfig::BehPardakhtUsername() . ':' . FwConfig::BehPardakhtPassword()),
				'Content-Type'  => 'application/json',
			], true);
			$finglify = new \Finglify();
			$res2 = CallAPI('post', 'https://bclub.pec.ir/api/api/GeneralApi/Register', [
				"AppKey"          => FwConfig::ParsianAppKey(),
				"AppSecret"       => FwConfig::ParsianAppSecret(),
				"FirstNameFa"     => $customer->first_name,
				"LastNameFa"      => $customer->last_name,
				"FirstNameEn"     => $finglify->translate($customer->first_name),
				"LastNameEn"      => $finglify->translate($customer->last_name),
				"NationalCode"    => $nationalCode,
				"CellNumber"      => "$mobile",
				"MappedCards"     => "",
				"CustomerGroupId" => 0,
				"CardGroupId"     => 238,
			], [
				'Content-Type' => 'application/x-www-form-urlencoded',
			], false, true);
			return response([json_decode($res1), json_decode($res2)], 202);
		});
		$router->get('/cards/:string', $this->middleware($router), function ($mobile) {
			$first = $mobile[0];
			$second = $mobile[1];
			if (!($first == 0 and $second == 9 and strlen($mobile) == 11)) {
				return response(['message' => 'mobile is not valid'], 400);
			}
			$customer = Customers::getByMobile($mobile);
			if ($customer instanceof CustomersEntity) {
				$data = CreditCards::getAllFiltered("customer_id", $customer->customer_id)->map(function (CreditCardsEntity $card) {
					return $card->apiFormat();
				})->filter(function ($value) {
					return $value['bank'] != NULL;
				});
				$output = [];
				foreach ($data as $datum) {
					$output[] = $datum;
				}
				return response($output, 200);
			} else {
				return response(['message' => 'User not found'], 404);
			}
		});
		$router->post('/cards', $this->middleware($router), function () {
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			/** @var CustomersEntity $customer */
			$customer = Customers::getByMobile($mobile);
			if ($customer instanceof CustomersEntity) {
				$startup = Startups::getByToken(get_header('token'));
				$startupUser = StartupUsers::getByStartup($customer->customer_id, $startup);
				if ($startupUser instanceof StartupUsersEntity) {
					$bank = Banks::get($this->getParam('bank_id'));
					$customerId = $customer->customer_id;
					if ($bank instanceof BanksEntity) {
						
						$bankCard = CreditCardsEntity::fromArray([
							'card_number'       => $this->getParam('cardNumber'),
							'card_cvv2'         => $this->getParam('cvv2'),
							'bank_id'           => $bank->bank_id,
							'customer_id'       => $customerId,
							'user_id'           => $startupUser->id,
							'card_expire_month' => $this->getParam('expireMonth'),
							'card_expire_year'  => $this->getParam('expireYear'),
						]);
						$cardNumber = $this->getParam('cardNumber');
						/** @var StartupUsersEntity $startupUser */
						if (CreditCards::Db()->where(['user_id' => $startupUser->id])->rowCount() < $startupUser->level()->level_max_card_count) {
							if (CreditCards::Db()->where('credit_card_number', 'like', "$cardNumber")->get()->length() === 0) {
								
								if ($bankCard instanceof CreditCardsEntity and $bankCard->save()) {
									$res2 = CallAPI('post', 'https://bclub.pec.ir/api/api/GeneralApi/MapCards', [
										"AppKey"       => FwConfig::ParsianAppKey(),
										"AppSecret"    => FwConfig::ParsianAppSecret(),
										"NationalCode" => $customer->national_code,
										"MappedCards"  => $cardNumber,
									], [
										'Content-Type' => 'application/x-www-form-urlencoded',
									], false, true);
									$res = '';
									$res = CallAPI('post', 'https://saheam.ir/webapi/clubservices/v2/AddMemberCard', [
										"NationalCode" => $customer->national_code,
										"Pans"         => [
											[
												'Pan'  => $cardNumber,
												'Type' => 0,
											],
										],
									], [
										'Authorization' => 'Basic ' . base64_encode(FwConfig::BehPardakhtUsername() . ':' . FwConfig::BehPardakhtPassword()),
										'Content-Type'  => 'application/json',
									], true);
									return response([
//									'res'  => $res,
'res2' => $res2,
									], 201);
								}
							} else {
								return response('Card number registered before', 200);
							}
						} else {
							return response('Max credit card limit exceeded', 400);
						}
					} else {
						return response('Bank not found', 404);
					}
				} else {
					return response('User not registered in startup', 404);
				}
			} else {
				return response('Customer not found', 404);
			}
			return response(NULL, 400);
		});
		$router->post('/deleteCard', function () {
			$cards = $this->getParam('cards', true, function ($cards) {
				return is_json($cards);
			});
			$cards = json_decode($cards, true);
			$mobile = $this->getParam('mobile', true, function ($mobile) {
				$first = $mobile[0];
				$second = $mobile[1];
				return $first == 0 and $second == 9 and strlen($mobile) == 11;
			});
			if (CreditCards::delete($cards)) {
				return response(NULL, 201);
			}
			return response(NULL, 400);
		});
		$router->get('/psp-list', $this->middleware($router), function () {
			$list = PaymentServiceProviders::getAll();
			$list = $list->map(function (PaymentServiceProvidersEntity $payment_service_provider) {
				return $payment_service_provider->apiFormat();
			});
			return response($list);
		});
		$router->get('/all-news', $this->middleware($router), function () {
			return response(LatestNews::getAllActives()->map(function (\model\Entity\LatestNewsEntity $entity) {
				return $entity->apiFormat();
			})->values());
		});
		$router->get('/main-news', $this->middleware($router), function () {
			$LatestNews = new \controller\LatestNews();
			return response(LatestNews::Db()->orderBy('')->get()->filter(function (LatestNewsEntity $entity) use ($LatestNews) {
				return isActive($LatestNews, $entity);
			})->limit(3)->map(function (LatestNewsEntity $entity) {
				return $entity->apiFormat();
			}));
		});
	}
	
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
