<?php

namespace routes;

use fwJson\Json;
use model\Startups;
use Api\BaseRouter;
use model\Customers;
use model\PaymentTable;
use FwCharge\ChargeClass;
use model\ChargeOperators;
use FwRoutingSystem\Router;
use controller\ChargeServices;
use model\Entity\StartupsEntity;
use site\helpers\ParsianPayment;
use model\Entity\CustomersEntity;
use model\Entity\ChargeOperatorsEntity;

class ChargesRoute extends BaseRouter {
	public $groupPath = 'charges';
	
	public function routes(Router $router) {
		$router->get('/operators', $this->middleware($router), function () {
			return response(ChargeOperators::getAll()->map(function (ChargeOperatorsEntity $entity) {
				return $entity->apiFormat();
			}));
		});
		$router->get('/operators/:string', $this->middleware($router), function ($mobile) {
			$chargeOperators = new ChargeServices();
			return response($chargeOperators->operatorFinder($mobile));
		});
		$router->post('/packageList', $this->middleware($router), function () {
			/** @var ChargeOperatorsEntity $operator */
			$operatorId = $this->getParam('operator');
			$type = $this->getParam('simType', true, function ($type) {
				return $type == 'prepaid' or $type == 'postpaid';
			}); // prepaid, postpaid
			$data = \MobinOneCharges::getPackages($operatorId, $type);
			$res = json_decode($data);
			if ($res->message == 'success') {
				return response(collect($res->data[0])->map(function ($item) {
					return [
						'code'         => $item->packageCode,
						'description'  => $item->packageDescription,
						'price'        => $item->packageCostWithVat,
						'durationCode' => $item->packageDurationCode,
					];
				}));
			}
			return response(['message' => 'An error occurred'], 400);
		});
		$router->post('/buyInternet', $this->middleware($router), function () {
			$customerMobile = $this->getParam('customerMobile');
			$mobile = $this->getParam('mobile');
			$operatorId = $this->getParam('operatorId');
			$packageCode = $this->getParam('packageCode');
			$packageCost = $this->getParam('packageCost');
			$callBack = $this->getParam('callback');
			/** @var CustomersEntity $customer */
			$customer = Customers::getByMobile($customerMobile);
			$Payment = new ParsianPayment();
			$Payment->UserModel(new Customers(), $customer);
			$Payment->initPayment(new PaymentTable())->Amount($packageCost + ($packageCost * (9/100)))->Type(ChargeClass::buyChargePayType);
			$Payment->OrderData(Json::encode([
				'callback'    => $callBack,
				'packageCode' => $packageCode,
				'packageCost' => $packageCost,
				'mobile'      => $mobile,
				'operatorId'  => $operatorId,
			]));
			$url = $Payment->goToPayment();
			if (filter_var($url, FILTER_VALIDATE_URL)) {
				$output['status'] = true;
				$output['url'] = $url;
			} else {
				$output['message'] = $url;
			}
			return response($output);
		});
		$router->post('/init', $this->middleware($router), function () {
			$operatorId = $this->getParam('operatorId');
			$chargeAmount = $this->getParam('chargeAmount');
			$mobile = $this->getParam('mobile');
			$callBack = $this->getParam('callback');
			if (!(Customers::getByMobile($mobile) instanceof CustomersEntity)) {
				$customer = Customers::get(Customers::quickAddMobile($mobile));
			} else {
				$customer = Customers::getByMobile($mobile);
			}
			$Payment = new ParsianPayment();
			$Payment->UserModel(new Customers(), $customer);
			$Payment->initPayment(new PaymentTable())->Amount($chargeAmount)->Type(ChargeClass::buyChargePayType);
			$Payment->OrderData(Json::encode([
				'callback' => $callBack,
			]));
			$ChargeClass = new ChargeClass();
			$url = $Payment->goToPayment();
			if (filter_var($url, FILTER_VALIDATE_URL)) {
				$output['status'] = true;
				$output['url'] = $url;
			} else {
				$output['message'] = $url;
			}
			return response($output);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
}
