<?php

namespace routes;

use model\Startups;
use controller\Cities;
use FwRoutingSystem\Router;
use model\Entity\StartupsEntity;

class BaseDataRouter extends \Api\BaseRouter {
	public $groupPath = 'base-data';
	
	public function routes(Router $router) {
		$router->get('/cities', $this->middleware($router), function () {
			$city = new Cities();
			return response($city->getActiveCities());
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
