<?php

namespace routes;

use model\States;
use model\Startups;
use model\BankCards;
use model\Countries;
use controller\Banks;
use controller\Cities;
use FwRoutingSystem\Router;
use model\Entity\BanksEntity;
use model\Entity\StatesEntity;
use model\Entity\StartupsEntity;
use model\Entity\BankCardsEntity;
use model\Entity\CountriesEntity;

class BaseDataRoute extends \Api\BaseRouter {
	public $groupPath = 'base-data';
	
	public function routes(Router $router) {
		$router->get('/countries', $this->middleware($router), function () {
			return response(Countries::getAllActives()->map(function (CountriesEntity $country) {
				return $country->apiFormat();
			})->values());
		});
		$router->get('/states/:id?', $this->middleware($router), function ($id = 0) {
			return response(States::getAllActives()->filter(function (StatesEntity $item) use ($id) {
				return $item->country_id == $id || $id == 0;
			})->map(function (StatesEntity $item) {
				return $item->apiFormat();
			})->values());
		});
		$router->get('/cities/:id?', $this->middleware($router), function ($id = 0) {
			$city = new Cities();
			return response($city->getActiveCities($id));
		});
		$router->post('/closest-city', $this->middleware($router), function () {
			$latitude = $this->getParam('latitude');
			$longitude = $this->getParam('longitude');
			return response(\model\Cities::getClosest($latitude, $longitude));
		});
		$router->get('/banks', $this->middleware($router), function () {
			$banks = new Banks();
			return response($banks->model()::getAll()->map(function (BanksEntity $bank) {
				return $bank->apiFormat();
			}));
		});
		$router->get('/banks/:string', $this->middleware($router), function ($prefix) {
			$result = BankCards::Db()->where('bankcard_type', 'like', $prefix)->get()->first;
			if ($result instanceof BankCardsEntity) {
				$bank = \model\Banks::get($result->bank_id);
				if ($bank instanceof BanksEntity) {
					return response($bank->apiFormat());
				}
			}
			return response(['message' => 'No bank was found'], 404);
		});
	}
	
	public function requiredHeaders() : array {
		return [
			'token' => function ($token) {
				return [
					'isCustom' => true,
					'validate' => Startups::getByToken($token) instanceof StartupsEntity,
					'message'  => [
						'message' => 'client not found',
						'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
					],
				];
			},
		];
	}
	
}
