<?
ini_set('session.save_path', '/tmp');
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);

use model\Castes;
use model\Startups;
use model\Customers;
use model\Providers;
use model\Countries;
use routes\ClubRoute;
use routes\CrudRoute;
use routes\HotelRoute;
use model\Individuals;
use routes\FlightRoute;
use routes\QrCodeRoute;
use model\PaymentTable;
use routes\ChargesRoute;
use routes\ServicesRoute;
use routes\BaseDataRoute;
use routes\InsuranceRoute;
use routes\ProvidersRoute;
use routes\NegaShopRoute;
use FwRoutingSystem\Router;
use model\ProviderBranches;
use model\ProviderToStartup;
use routes\SocialMediaRoute;
use routes\VoucherCodesRoute;
use model\Entity\CastesEntity;
use site\helpers\ParsianPayment;
use model\Entity\StartupsEntity;
use model\Entity\CustomersEntity;
use model\Entity\CountriesEntity;
use model\Entity\ProvidersEntity;
use model\Entity\ProviderBranchesEntity;
use model\Entity\ProviderToStartupEntity;

include '../admin/src/autoload.php';
define('__API__', __DIR__ . '/routes/');
define("__HOST__", "https://api.negahub.com/");
define('__IMAGES__', 'https://img.negahub.com/');
$Router = new Router();
header('Content-Type: application/json');
define('global_error', "Unknown error!");
function response($content, $statusCode = 200) {
	http_response_code($statusCode);
	return is_iterable($content) ? json_encode($content, JSON_UNESCAPED_UNICODE) : $content;
}
$Router->get('/test',function (){
	$str = "{\"CardId\":\"FDWMC3pgB1rHwe/cjbS6KynOt/oQRC5DHAxvMj3yX7s=\"}";
	return json_decode($str)->CardId;
});
$Router->post('/sms/:any', function ($mobile) {
	ini_set("soap.wsdl_cache_enabled", "0");
	$sms_client = new SoapClient('http://payamak-service.ir/SendService.svc?wsdl', ['encoding' => 'UTF-8']);
	try {
		$parameters['userName'] = "mt.09396329984";
		$parameters['password'] = "mb@110591356";
		$parameters['fromNumber'] = "50005708633022";
		$parameters['toNumbers'] = ["$mobile"];
		$parameters['messageContent'] = $_POST['text'];
		$parameters['isFlash'] = false;
		$recId = [];
		$status = [];
		$parameters['recId'] = &$recId;
		$parameters['status'] = &$status;
		return response($sms_client->SendSMS($parameters)->SendSMSResult);
	} catch(Exception $e) {
		return response('error', 404);
	}
});
$Router->get('/generateComments',function (){
	header('Content-Type: text/html');
	$emojies = explode("\n","❤
	️😍
	👍
	🔥
	💜
	😈
	🫀
	💋
	🦋
	🦄
	🌺
	🐚
	💫
	✨
	🤍
	❤
	️‍🔥
	🌸
	🌞
	🦩");
	$texts = "Nice
Wow
عالیه
به پیج منم سر بزنین
چه عکسای خفنی
چه خفن
کارت عالیه موفق باشی
Good luck
حرف نداره کارات
ادیت ها همه عالی";
	$generated = [];
	$texts = explode("\n",$texts);
	foreach ($texts as $text) {
		$randomEmoji = array_rand($emojies);
		$generated[] = $text.$emojies[$randomEmoji];
	}
	foreach ($texts as $text) {
		$randomEmoji = array_rand($emojies);
		$generated[] = $text.$emojies[$randomEmoji];
	}
	$emojies = array_chunk($emojies,2);
	foreach ($emojies as $emojy) {
		$types = calculatePermutations(implode('',$emojy));
		foreach ($types as $type) {
			if (!in_array($type,$generated)){
				$generated[] = $type;
			}
		}
	}
	echo implode('<br>',$generated);
});
$Router->any('/', function () {
	return response([], 404);
});
$Router->error(function () {
	echo response(['message' => 'endpoint not found'], 404);
});
$Router->use(NegaShopRoute::class);

$Router->use(InsuranceRoute::class);
$Router->use(ServicesRoute::class);
$Router->use(ProvidersRoute::class);
$Router->use(BaseDataRoute::class);
$Router->use(ChargesRoute::class);
$Router->use(VoucherCodesRoute::class);
$Router->use(FlightRoute::class);
$Router->use(HotelRoute::class);
$Router->use(QrCodeRoute::class);
$Router->use(ClubRoute::class);
$Router->use(CrudRoute::class);
$Router->use(SocialMediaRoute::class);
$Router->get('/pay', function () {
	$Payment = new ParsianPayment();
	$mobile = '09396329984';
	$amount = $_GET['amount'];
	$customer = Customers::getByMobile($mobile);
	if (!($customer instanceof CustomersEntity)) {
		$customer = Customers::get(Customers::quickAddMobile($mobile));
	}
	$Payment->UserModel(new Customers(), $customer);
	$Payment->initPayment(new PaymentTable());
	$Payment->Amount($amount);
	$Payment->Type('test_payment');
	$url = $Payment->goToPayment();
	if (filter_var($url, FILTER_VALIDATE_URL)) {
		header('Location: ' . $url);
	} else {
		echo 'error';
	}
});
$Router->get('/caste-list/:any', function ($id = 15) {
	$casteList = Castes::getAllActives()->filter(function (CastesEntity $entity) use ($id) {
		return $entity->workgroup_id == $id;
	});
	$i = 0;
	/** @var CastesEntity $item */
	header('Content-Type: text/html');
	echo "<body style='direction: rtl'>";
	foreach ($casteList as $item) {
		$i++;
		echo "$i- " . $item->name . '<br><br>';
	}
	echo "</body>";
});
$Router->get('/caste-list', function () {
	$casteList = Castes::getAllActives();
	$i = 0;
	/** @var CastesEntity $item */
	header('Content-Type: text/html');
	echo "<body style='direction: rtl'>";
	foreach ($casteList as $item) {
		$i++;
		echo "$i- " . $item->name . '<br><br>';
	}
	echo "</body>";
});
$Router->get('/import', function () {
	set_time_limit(0);
	/** @var ProviderToStartupEntity $item */
	/** @var StartupsEntity $startup */
	$startup = Startups::get(40);
	$percent = $startup->startup_percent + $startup->startup_hub_percent;
	foreach (ProviderToStartup::getAllFiltered('startup_id', 40) as $item) {
		$discount = $item->to_startup_cash_discount;
		if (!$discount) $discount = 0;
		if ($percent > $discount) {
			$percent = $discount;
		}
		echo "<br>";
		$item->cashback_percent = 0;
		$item->startup_percent = $percent;
		var_dump($item->save());
		echo "<br>";
		echo "<br>";
	}
	return;
	/** @var ProviderToStartupEntity $item */
	foreach (ProviderToStartup::getAllFiltered('startup_id', 39) as $item) {
		$branches = ProviderBranches::getAllFiltered("provider_id", $item->provider_id);
		/** @var ProviderBranchesEntity $branch */
		foreach ($branches as $branch) {
			$branch->state_id = 22;
			$branch->city_id = 17;
			var_dump($branch->save());
			echo "<br>";
		}
	}
	return;
	/** @var BaseEntity $item */
	foreach (Castes::getAll() as $item) {
		var_dump($item->setActive());
		echo "<br>";
	}
	return;
	set_time_limit(0);
	/** @var ProvidersEntity $provider */
	foreach (Providers::getAll() as $provider) {
		if (str($provider->name)->len() <= 2) {
			foreach (ProviderBranches::getAllFiltered('provider_id', $provider->provider_id) as $branch) {
				var_dump($branch->delete());
				echo "<br>";
			}
			var_dump($provider->delete());
			echo "<br>";
			echo "<br>";
		}
	}
	return;
	var_dump(Providers::get(99));
	/** @var ProviderBranchesEntity $providerBranch */
	foreach (ProviderBranches::getAll() as $providerBranch) {
		$provider = Providers::get($providerBranch->provider_id);
		var_dump($provider);
		if (!($provider instanceof ProvidersEntity)) {
			var_dump($providerBranch->delete());
			echo "<br>";
		}
	}
	return;
	set_time_limit(0);
	$conn = new PDO("mysql:host=localhost;dbname=rahyab_database;charset=utf8", 'rahyab_user', 'mb@110591356', [PDO::ATTR_PERSISTENT => true]);
	$result = $conn->query("SELECT * FROM tblProviders");
	$output = [];
	while ($row = $result->fetchObject()) {
		
		$firstName = $row->provider_first_name;
		$lastName = $row->provider_last_name;
		$mobile = $row->provider_mobile;
		$telephone = $row->provider_telephone;
		$name = $row->provider_senf_unit_name;
		$workgroup_id = $row->workgroup_id;
		$caste_id = $row->caste_id;
		$offer = 1;
		/** @var CountriesEntity $country */
		$country = Countries::Db()->orderBy('country_id', false)->limit(1)->get();
		echo 'individual' . "<br>";
		if (!(Individuals::getOneFiltered('individual_mobile', "0$mobile") instanceof IndividualsEntity)) {
			$individual = Individuals::add([
				'individual_first_name' => $firstName,
				'individual_last_name'  => $lastName,
				'individual_gender'     => 1,
				'individual_mobile'     => $mobile,
				'country_id'            => $country->country_id,
			]);
			echo '$provider' . "<br>";
			$provider = Providers::add([
				'provider_manager' => $individual,
				'provider_name'    => $name,
				'provider_tel'     => $telephone,
				'workgroup_id'     => $workgroup_id,
				'caste_id'         => $caste_id,
				'social_media_ids' => json_encode(90),
				'provider_offer'   => $offer,
			]);
			echo '$branch' . "<br>";
			$branch = ProviderBranches::add([
				'provider_branch_name'             => 'شعبه مرکزی',
				'provider_manager'                 => $individual,
				'country_id'                       => $country->country_id,
				'state_id'                         => $row->state_id,
				'city_id'                          => $row->city_id,
				'district_id'                      => 0,
				'range_id'                         => 0,
				'district_ids'                     => json_encode([]),
				'provider_id'                      => $provider,
				'provider_branch_main_street'      => $row->provider_main_street,
				'provider_branch_secondary_street' => $row->provider_second_street,
				'provider_branch_address_full'     => $row->provider_address,
				'provider_branch_plaque'           => $row->provider_pelak,
			]);
			echo '$startup' . "<br>";
			$startup = ProviderToStartup::add([
				'startup_id'                            => 40,
				'provider_branch_id'                    => json_encode($branch),
				'provider_to_startup_contract_number'   => $row->providers_number,
				'provider_to_startup_start_date'        => $row->provider_start_date,
				'provider_to_startup_end_date'          => $row->provider_end_date,
				'contracttype_id'                       => $row->contracttype_id,
				'provider_to_startup_credit_discount'   => $row->provider_discount_credit,
				'provider_to_startup_cash_discount'     => $row->provider_discount_cash,
				'provider_to_startup_month_ssettlement' => $row->provider_payment_period,
				'provider_to_startup_each_buy'          => $row->provider_each_buy,
				'provider_to_startup_score_per_buy'     => $row->provider_score_per_buy,
				'provider_id'                           => $provider,
				'provider_to_startup_date'              => time(),
				'is_universal'                          => 0,
			]);
			var_dump($startup);
		}
		echo "<br>";
	}
});
$Router->any(':all/:all?/:all?/:all?/:all?/:all?', function () {
	return response(['message' => 'endpoint not found'], 404);
});
