<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwAuthSystem\Main\UserObject;
use model\Entity\IndividualsEntity;
use View;

class Visitors extends View
{

    public $SingularName = 'ویزیتور';
    public $PluralName = 'ویزیتورها';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام '),
                                                                    HtmlTags::Th('نام خانوادگی'),
                                                                    HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('نام کاربری'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'individual_first_name'=>new \model\Individuals(),
                                                                    'individual_last_name'=>new \model\Individuals(),
                                                                    'showImage'=>'visitor_image',
                                                                    'visitor_username'], true, true, false, function ($item) {
                                                                    return HtmlTags::Button('.btn.btn-outline-warning.m-1.ajax')->Content(
                                                                        HtmlTags::I('.fa.fa-map-marker')
                                                                    )->Data_('toggle', 'tooltip')->Title('آدرس ویزیتور')->Rel((new \controller\VisitorAddresses())->RelPath(['visitor_id' => $item->visitor_id
                                                                    ]));
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        $this->Html()->isDebug();
        $uniqe = UniqueOfClass(new \model\Visitors(), 'visitor_introduction', false, 6, false, false);

        $married = HtmlTags::Option()->Selected()->Disabled()->Value("")->Content("لطفا یک گزینه را انتخاب کنید");
        $married .= HtmlTags::Option()->Value("1")->Content("مجرد");
        $married .= HtmlTags::Option()->Value("2")->Content("متاهل");
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('انتخاب شخص') .
                                        $this->quickAdd(
                                            $this->Html()->Select('individual_id', 'individual_id', \model\Individuals::toOption(UserObject::instance())),
                                            new \controller\Individuals()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('سطح عضویت') .
                                        $this->Html()->Select('level_id','',\model\Levels::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کد ملی') .
                                        $this->Html()->Input('visitor_national_code') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('سریال شناسنامه') .
                                        $this->Html()->Input('visitor_identity_serial') .

                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تاریخ تولد') .
                                        $this->Html()->Input('visitor_birthday') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام پدر') .
                                        $this->Html()->Input('visitor_father_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('استان') .
                                        $this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('شهر') .
                                        $this->Html()->Select('city_id', 'city_id',\model\Cities::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('آدرس') .
                                        $this->Html()->Input('visitor_address', 'visitor_address') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label(' تلفن') .
                                        $this->Html()->Tel('visitor_tell') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کد پستی') .
                                        $this->Html()->Input('visitor_postal_code') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('مکان تولد') .
                                        $this->Html()->Input('visitor_birthplace') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('وضعیت تاهل') .
                                        $this->Html()->Select('visitor_marital_status','visitor_marital_status',$married) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تعداد فرزندان') .
                                        $this->Html()->NumberInput('visitor_number_children','0','100','1','','0') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('آدرس ایمیل') .
                                        $this->Html()->Email('visitor_email') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام کاربری') .
                                        $this->Html()->Input('visitor_username') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کلمه عبور') .
                                        $this->Html()->Password('visitor_password') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر') .
                                        $this->Html()->ImageInput('visitor_image') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز') .
                                        $this->Html()->Number('visitor_score') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار') .
                                        $this->Html()->Price('visitor_credit') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6, '', 'div_visitor_introduction') .
                                        $this->Html()->Label('کد معرفی') .
                                        $this->Html()->Input('visitor_introduction', 'visitor_introduction', $uniqe) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6, '') .
                                        $this->Html()->Label('کد معرفی کننده(اختیاری)') .
                                        $this->Html()->Input('visitor_introduction_from','visitor_introduction_from','',false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('توضیحات') .
                                        $this->Html()->TextArea('visitor_description') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                ).$this->quickAddModals();
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
