<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class VisitorAddresses extends View
{

    public $SingularName = 'آدرس ویزیتور';
    public $PluralName = 'آدرس ویزیتور ها';

    public function main(Document &$document)
    {

        $echo = false;
        if ($_REQUEST['visitor_id']) {
            $echo = true;
            $nameData = (new \model\Visitors())->get($_REQUEST['visitor_id']);
        }

        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd('', ['visitor_id', $_REQUEST['visitor_id']]),
                                                ( $echo ? 'آدرس های ' . $nameData->visitor_first_name . ' ' . $nameData->visitor_last_name : '')
                                            ),

                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام و نام خانوادگی'),
                                                                    HtmlTags::Th('استان'),
                                                                    HtmlTags::Th('شهر'),
                                                                    HtmlTags::Th('منطقه'),
                                                                    HtmlTags::Th('خیابان اصلی'),
                                                                    HtmlTags::Th('خیابان فرعی'),
                                                                    HtmlTags::Th('آدرس دقیق'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'visitor_id' => function ($visitor_id) {
                                                                        $visitor = \model\Visitors::get($visitor_id);
                                                                        $visitor = \model\Individuals::get($visitor->individual_id);
                                                                        return $visitor->individual_first_name . ' ' . $visitor->individual_last_name;
                                                                    },
                                                                    'state_name'=>new \model\States() ,
                                                                    'city_name' => new \model\Cities() ,
                                                                    'district_name' => new \model\Districts() ,
                                                                    'visitor_address_main_street',
                                                                    'visitor_address_secondary_street',
                                                                    'visitor_address_full',

                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        $nameRow = '';

        if ($_GET[1]) {
            $nameData = \model\Visitors::get($_GET[1]);
            $nameRow = '<option value="' . $nameData->visitor_id . '">' . $nameData->visitor_first_name . ' ' . $nameData->visitor_last_name . ' ' . $nameData->visitor_mobile . '</option>';
            $echo = true;
        } else {
            $name_all = \model\ProductsName::getAllActives();
            $nameRow .= '<option value="">یک گزینه را انتخاب کنید</option>';
            foreach ($name_all as $i) {
                $nameRow .= '<option value="' . $i->visitor_id . '">' . $i->visitor_first_name . ' ' . $i->visitor_last_name . ' ' . $i->visitor_mobile . '</option>';
            }
        }

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('انتخاب ویزیتور') .
                                        $this->Html()->Select('visitor_id', 'visitor_id', $nameRow) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کشور') .
                                        $this->Html()->Select('country_id', 'country_id',\model\Countries::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب استان') .
                                        $this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب شهر') .
                                        $this->Html()->Select('city_id', 'city_id',\model\Cities::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب منطقه') .
                                        $this->Html()->Select('district_id', 'district_id', \model\Districts::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('خیابان اصلی') .
                                        $this->Html()->Input('visitor_address_main_street') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('خیابان فرعی') .
                                        $this->Html()->Input('visitor_address_secondary_street') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(9) .
                                        $this->Html()->Label('آدرس دقیق') .
                                        $this->Html()->Input('visitor_address_full') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('پلاک') .
                                        $this->Html()->Input('visitor_address_plaque') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('نقشه') .
//                                        $this->MapMarker('visitor_address_latitude', 'visitor_address_longitude') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('عرض جغرافیایی') .
                                        $this->Html()->Input('visitor_address_latitude') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('طول جغرافیایی') .
                                        $this->Html()->Input('visitor_address_longitude') .
                                        $this->Html()->FormGroupEnd().
                                        $this->Html()->CardFooter()


                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
