<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\FontAwesome;
use FwHtml\Elements\Tags\Main\HtmlTags;

class VoucherCodes extends View {
	
	public $SingularName = 'کد تخفیف';
	public $PluralName = 'کد های تخفیف';
	
	
	public function upload(Document $document) {
		$this->submit();
		
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle('بارگذاری'),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										controllerType('uploadExcel'),
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب تامین کننده') .
										$this->Html()->Select('voucher_code_provider_id', 'voucher_code_provider_id', \model\VoucherCodeProviders::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تعداد استفاده برای هر کاربر') .
										$this->Html()->Input('voucher_code_user_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('درصد تخفیف') .
										$this->Html()->Percent('voucher_code_percent') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('توضیحات') .
										$this->Html()->Input('voucher_code_description') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('آپلود فایل') .
										$this->Html()->ExcelInput('voucher_codes_excel') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter('بارگذاری', false, HtmlTags::Button('.btn.btn-success.btn-lg')->Attrs([
											'type' => 'submit',
											'name' => 'submit',
										])->Content(
											HtmlTags::I()->Class(FontAwesome::Upload()),
											' ',
											"بارگذاری"
										)->Attrs([
											'style' => 'width: 100%;',
										])
										)
									)
							)
						)
				);
	}
	
	public function main(Document &$document) {
		
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->backBtn(),
												$this->Html()->refreshAndAdd(),
												$this->Html()->topBtn('^upload^VoucherCodes/VoucherCodes/VoucherCodes', 'بارگذاری', FontAwesome::File_excel_o(), 'success')
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کد تخفیف'),
																	HtmlTags::Th('تعداد کل'), HtmlTags::Th('تعداد استفاده برای هر کاربر'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																	HtmlTags::Th('.no-sort وضعیت')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'voucher_code',
																	'voucher_code_count',
																	'voucher_code_user_count',
																],
																	true,
																	true,
																	true
																)
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function groups(Document &$document) {
		
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndAdd(),
												$this->Html()->topBtn('^upload^VoucherCodes/VoucherCodes/VoucherCodes', 'بارگذاری', FontAwesome::File_excel_o(), 'success')
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام تامین کننده'),
																	HtmlTags::Th('درصد تخفیف'),
																	HtmlTags::Th('تاریخ ثبت'),
																	HtmlTags::Th('تعداد کد ها'),
																	HtmlTags::Th()->Content('#'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																		'voucher_code_provider_name' => new \model\VoucherCodeProviders(),
																		'percent'                    => function ($percent) {
																			return "$percent%";
																		},
																		'voucher_code_submit_date'   => function ($date) {
																			return jdate('Y/m/d-H:i:s', $date);
																		},
																		'count',
																		function ($date) {
																			return HtmlTags::Button('.btn.btn-primary.w-100.ml-auto.mr-auto.ajax')->Content(
																				'کد های تخفیف این گروه'
																			)->Attrs(['rel' => ("VoucherCodes/VoucherCodes/VoucherCodes?codeGroup={$date->voucher_code_submit_date}")]);
																		},
																	]
																)
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('کد تخفیف') .
										$this->Html()->Input('voucher_code') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('انتخاب تامین کننده') .
										$this->Html()->Select('voucher_code_provider_id', 'voucher_code_provider_id', \model\VoucherCodeProviders::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تعداد کل') .
										$this->Html()->Number('voucher_code_count', 'voucher_code_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تعداد استفاده برای هر کاربر') .
										$this->Html()->Input('voucher_code_user_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('درصد تخفیف') .
										$this->Html()->Percent('voucher_code_percent') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('توضیحات') .
										$this->Html()->Input('voucher_code_description') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
