<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\FontAwesome;
use model\Entity\VoucherCodesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class VoucherCodeServices extends View {
	
	public $SingularName = 'سرویس تخفیف';
	public $PluralName = 'سرویس های تخفیف';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndAdd(),
												$this->Html()->topBtn('^upload^VoucherCodes/VoucherCodeServices/VoucherCodeServices', 'بارگذاری', FontAwesome::File_excel_o(), 'success')
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('استارتاپ'),
																	HtmlTags::Th('تامین کننده کد'),
																	HtmlTags::Th('کد'),
																	HtmlTags::Th('تاریخ پایان اعتبار سرویس'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'startup_name'                     => new \model\Startups(),
																	'voucher_code_id'                  => function ($voucherCodeId) {
																		return \model\VoucherCodeProviders::get(\model\VoucherCodes::get($voucherCodeId)->voucher_code_provider_id)->code_provider_name;
																	},
																	'voucher_code'                     => new \model\VoucherCodes(),
																	'voucher_code_service_expire_date' => function ($date) {
																		return jdate('Y/m/d', $date);
																	},
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document $document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('استارتاپ') .
										$this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) . $this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('کد تخفیف') .
										$this->Html()->Select('voucher_code_id', 'voucher_code_id', \model\VoucherCodes::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('حداکثر تعداد درخواست  این کد') .
										$this->Html()->Number('voucher_code_service_count', 'voucher_code_service_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(8) .
										$this->Html()->Label('حداکثر تعداد درخواست  این کد برای هر کاربر در این استارتاپ') .
										$this->Html()->Number('voucher_code_service_user_count', 'voucher_code_service_user_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تاریخ پایان اعتبار سرویس') .
										$this->Html()->Input('voucher_code_service_expire_date') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function upload(Document $document) {
		$this->submit();
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle('بارگذاری'),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										controllerType('uploadExcel'),
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('استارتاپ') .
										$this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) . $this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(8) .
										$this->Html()->Label('حداکثر تعداد درخواست  این کد برای هر کاربر در این استارتاپ') .
										$this->Html()->Number('voucher_code_service_user_count', 'voucher_code_service_user_count') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تاریخ پایان اعتبار سرویس') .
										$this->Html()->Input('voucher_code_service_expire_date') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('آپلود فایل') .
										HtmlTags::Br(),
										HtmlTags::Div('.form-group.col-md-6.d-flex')->Content(
											HtmlTags::Input()->Type('checkbox')->Id('checkAll'),
											HtmlTags::Label('.mr-1')->Content(" انتخاب همه")
										),
										HtmlTags::Table('.table.table-bordered')->Content(
											HtmlTags::Thead('.table-dark')->Content(
												HtmlTags::Tr()->Content(
													HtmlTags::Th()->Content('ردیف')->Width(50),
													HtmlTags::Th()->Content('#'),
													HtmlTags::Th()->Content('کد'),
													HtmlTags::Th()->Content('درصد'),
													HtmlTags::Th()->Content('تامین کننده')
												)
											),
											HtmlTags::Tbody()->Content(
												function () {
													/** @var VoucherCodesEntity $voucherCode */
													$output = [];
													foreach (\model\VoucherCodes::getAllActives() as $voucherCode) {
														$output[] = HtmlTags::Tr()->Content(
															HtmlTags::Td(),
															HtmlTags::Td()->Content(
																HtmlTags::Input()->Type('checkbox')
																	->Name('voucher_code_ids[]')
																	->Value($voucherCode->code)
															),
															HtmlTags::Td()->Content(
																$voucherCode->code
															),
															HtmlTags::Td()->Content(
																"$voucherCode->percent"
															),
															HtmlTags::Td()->Content(
																\model\VoucherCodeProviders::get($voucherCode->code_provider_id)->code_provider_name
															)
														);
													}
													return $output;
												}
											)
										),
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter('بارگذاری', false, HtmlTags::Button('.btn.btn-success.btn-lg')->Attrs([
											'type' => 'submit',
											'name' => 'submit',
										])->Content(
											HtmlTags::I()->Class(FontAwesome::Upload()),
											' ',
											"بارگذاری"
										)->Attrs([
											'style' => 'width: 100%;',
										])
										)
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
