<?

namespace view;

use DOMWrap\Document;
use model\Entity\SocialMediasEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class TransactionHistorys extends View
{

    public $SingularName = 'تراکنش';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'),
                                                                    HtmlTags::Th('صنف'),
                                                                    HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150'),
                                                                    HtmlTags::Th('.no-sort وضعیت')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'provider_name',
                                                                    'caste_name' => new \model\Castes(),
                                                                    'showImage' => 'provider_image',
                                                                ], true, true, true))

                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('مشتری ') .
                                        $this->Html()->Select('customer_id', 'customer_id', \model\Customers::toOption()) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز') .
                                        $this->Html()->Number('score_before') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار') .
                                        $this->Html()->Price('credit_before') .
                                        $this->Html()->FormGroupEnd() .

//                                        $this->Html()->FormGroupStart(4) .
//                                        $this->Html()->Label('تخصیص امتیاز') .
//                                        $this->Html()->Number('score_after') .
//                                        $this->Html()->FormGroupEnd() .
//
//                                        $this->Html()->FormGroupStart(4) .
//                                        $this->Html()->Label('تخصیص اعتبار') .
//                                        $this->Html()->Price('credit_after') .
//                                        $this->Html()->FormGroupEnd() .

//                                        $this->Html()->FormGroupStart(12) .
//                                        $this->Html()->Label('تبدیل امتیاز و اعتبار') .
//                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('استارت آپ') .
                                        $this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز در استارت آپ') .
                                        $this->Html()->Number('startup_user_score') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار در استارت آپ') .
                                        $this->Html()->Price('startup_user_credit') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(12) .
                                        '
                                         <br>  <br>
                                         <div class="infoBox">
                                          <div class="card text-white" style="background-color: #41b8cc">
                                          <div id="stsBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل امتیاز به امتیاز <span class="badge badge-warning">کلیک کنید</span></div>
                                              <div class="card-body text-center"> هر <span id="sts" class="text-body"> چند </span> امتیاز  <span class="sn text-body" > استارت آپ </span> برابر است با <span id="sfs" class=" text-body"> چند </span> امتیاز نگاهاب</div>
                                          
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_score">
                                           <label for="demo" class="sTOs">مقدار امتیاز را وارد کنید</label>
                                         <div class="input-group mb-3">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="score_to_club_score" name="score_to_club_score">
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="club_score_from_score">
                                          <label for="demo" class="sTOs">مقدار افزایش امتیاز</label>
                                        <div class="input-group mb-3">
                                          <input type="text" class="form-control" id="club_score_from_score" name="club_score_from_score">
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        '<div class="infoBox">
                                           <div class="card text-white" style="background-color: #41b8cc">
                                           <div id="stcBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل امتیاز به اعتبار<span class="badge badge-warning">کلیک کنید</span>  </div>
                                             <div class="card-body text-center"> هر <span id="stc" class="text-body"> چند </span> امتیاز  <span class="sn text-body"> استارت آپ </span> برابر است با <span id="cfs" class=" text-body"> چند </span> اعتبار نگاهاب</div>
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_credit">
                                           <label for="demo" class="sTOs">مقدار امتیاز را وارد کنید</label>
                                         <div class="input-group mb-3">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="score_to_club_credit" name="score_to_club_credit">
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="club_credit_from_score">
                                          <label for="demo" class="sTOs">مقدار افزایش اعتبار</label>
                                        <div class="input-group mb-3">
                                          <input type="text" class="form-control" id="club_credit_from_score" name="club_credit_from_score">
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(12) .
                                        '<div class="infoBox">
                                           <div class="card text-white" style="background-color: #41b8cc">
                                           <div id="ctsBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل اعتبار به امتیاز<span class="badge badge-warning">کلیک کنید</span></div>
                                             <div class="card-body text-center"> هر <span id="cts" class="text-body"> چند </span> اعتبار  <span class="sn text-body"> استارت آپ </span> برابر است با <span id="sfc" class=" text-body"> چند </span> امتیاز نگاهاب</div>
                                           </div>
                                           </div>
                                                                                 ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        '
                                         <div class="credit_to_club_score">
                                           <label for="demo" class="sTOs">مقدار اعتبار را وارد کنید</label>
                                         <div class="input-group mb-3">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="credit_to_club_score" name="credit_to_club_score">
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(6) .
                                        '
                                         <div class="club_score_from_credit">
                                          <label for="demo" class="sTOs">مقدار افزایش امتیاز</label>
                                        <div class="input-group mb-3">
                                          <input type="text" class="form-control" id="club_score_from_credit" name="club_score_from_credit">
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('امتیاز جدید نگاهاب') .
                                        $this->Html()->Number('new_score') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('اعتبار جدید نگاهاب') .
                                        $this->Html()->Price('new_credit') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function Table()
    {
        $data = json_decode($this->getData()->social_media_ids, true);
        $this->initDataTable = false;

        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th('.no-sort')->Content("ردیف"),
                    HtmlTags::Th('.no-sort')->Content("#"),
                    HtmlTags::Th()->Content("نام شبکه"),
                    HtmlTags::Th()->Content("آیکون")->Width('100'),
                    HtmlTags::Th('.no-sort')->Content("آدرس")
                )
            ),
            HtmlTags::Tbody()->Content(

                function () use ($data) {
                    $row = '0';
                    $output = [];
                    /** @var SocialMediasEntity $socialMedia */
                    foreach (\model\SocialMedias::getAll() as $socialMedia) {
                        $image = $socialMedia->social_media_icon;
                        $row++;
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td()->Content("$row"),
                            HtmlTags::Td()->Content(
                                HtmlTags::Input()
                                    ->Attrs(['checked' => isset($data[$socialMedia->social_media_id])])
                                    ->Type('checkbox')->Class('socialMediaCheckBox')
                            ),
                            HtmlTags::Td()->Content(
                                $socialMedia->social_media_name
                            ),
                            HtmlTags::Td()->Content(
                                '<img src="src/images/SocialMedias/' . $image . '"style="width: 100px;height=100px">'
                            ),
                            HtmlTags::Td()->Content(
                                $this->Html()->Input("social_media_ids[$socialMedia->social_media_id]")->Disabled(!isset($data[$socialMedia->social_media_id]))->Required(false)
                            )
                        );
                    }
                    return $output;
                }
            )
        );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
