<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use model\Entity\SocialMediasEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class CreditConversion extends View
{

    public $SingularName = 'تراکنش';


    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('استارت آپ'),
                                                                    HtmlTags::Th('مشتری'),
                                                                    HtmlTags::Th('اعتبار پس از تراکنش'),
                                                                    HtmlTags::Th('امتیاز پس از تراکنش'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'startup_name' => new \model\Startups(),
                                                                    'customer_lname' => new \model\Customers(),
                                                                    'score_after' ,
                                                                    'credit_after' ,
                                                                ], false, false, false))

                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        $Instance = UserObject::instance();

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('مشتری ') .
                                        $this->Html()->Select('customer_id', 'customer_id', \model\Customers::toOption()) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز') .
                                        $this->Html()->Number('score_before') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار') .
                                        $this->Html()->Price('credit_before') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('استارت آپ') .
                                        $this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز در استارت آپ') .
                                        $this->Html()->Number('startup_user_score') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار در استارت آپ') .
                                        $this->Html()->Price('startup_user_credit') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(12) .
                                        '
                                         <br>  <br>
                                         <div class="infoBox">
                                          <div class="card text-white" style="background-color: #41b8cc">
                                          <div id="stsBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل امتیاز به امتیاز <span class="badge badge-warning">کلیک کنید</span></div>
                                              <div class="card-body text-center"> هر <span id="sts" class="text-body"> چند </span> امتیاز  <span class="sn text-body" > استارت آپ </span> برابر است با <span id="sfs" class=" text-body"> چند </span> امتیاز نگاهاب</div>
                                          
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_score">
                                           <label for="demo" class="sTOs">مقدار امتیاز را وارد کنید</label>
                                           <div class="input-group mb-3 ">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="score_to_club_score" >
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="club_score_from_score">
                                          <label for="demo" class="sTOs">مقدار افزایش امتیاز</label>
                                        <div class="input-group mb-3 ">
                                          <input type="text" class="form-control" id="club_score_from_score" >
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_score">
                                           <label for="demo" class="sTOs">جهت محاسبه روی دکمه کلیک کنید</label>
                                         <div class="input-group mb-3 input-group-append">
                                           <span type="button" class="sTOsBTN btn btn-success w-100">محاسبه</span>
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        '<div class="infoBox">
                                           <div class="card text-white" style="background-color: #41b8cc">
                                           <div id="stcBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل امتیاز به اعتبار<span class="badge badge-warning">کلیک کنید</span>  </div>
                                             <div class="card-body text-center"> هر <span id="stc" class="text-body"> چند </span> امتیاز  <span class="sn text-body"> استارت آپ </span> برابر است با <span id="cfs" class=" text-body"> چند </span> اعتبار نگاهاب</div>
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_credit">
                                           <label for="demo" class="sTOs">مقدار امتیاز را وارد کنید</label>
                                         <div class="input-group mb-3">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="score_to_club_credit" >
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="club_credit_from_score">
                                          <label for="demo" class="sTOs">مقدار افزایش اعتبار</label>
                                        <div class="input-group mb-3 ">
                                          <input type="text" class="form-control" id="club_credit_from_score" >                                         
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="score_to_club_credit">
                                           <label for="demo" class="sTOs">جهت محاسبه روی دکمه کلیک کنید</label>
                                          <span type="button" class="sTOcBTN btn btn-success w-100">محاسبه</span>
                                        
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        '<div class="infoBox">
                                           <div class="card text-white" style="background-color: #41b8cc">
                                           <div id="ctsBTN" type="button" class="btn btn-outline-dark btn-lg">تبدیل اعتبار به امتیاز<span class="badge badge-warning">کلیک کنید</span></div>
                                             <div class="card-body text-center"> هر <span id="cts" class="text-body"> چند </span> اعتبار  <span class="sn text-body"> استارت آپ </span> برابر است با <span id="sfc" class=" text-body"> چند </span> امتیاز نگاهاب</div>
                                           </div>
                                           </div>
                                                                                 ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="credit_to_club_score">
                                           <label for="demo" class="sTOs">مقدار اعتبار را وارد کنید</label>
                                         <div class="input-group mb-3 ">
                                           <input type="text" class="form-control" placeholder="مثال:2" id="credit_to_club_score" >
                                         </div>
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="club_score_from_credit">
                                          <label for="demo" class="sTOs">مقدار افزایش امتیاز</label>
                                        <div class="input-group mb-3">
                                          <input type="text" class="form-control" id="club_score_from_credit" >
                                        </div>
                                        </div>
                                        ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        '
                                         <div class="credit_to_club_score">
                                           <label for="demo" class="sTOs">جهت محاسبه روی دکمه کلیک کنید</label>
                                          <span type="button" class="cTOsBTN btn btn-success w-100">محاسبه</span>
                                        
                                         </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('امتیاز جدید نگاهاب') .
                                        $this->Html()->Number('score_after','score_after','',false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('اعتبار جدید نگاهاب') .
                                        $this->Html()->Price('credit_after','credit_after','','',false) .
                                        $this->Html()->FormGroupEnd() .

                                        hiddenInput('','score_to_club_score','hideSTS').
                                        hiddenInput('','club_score_from_score','hideSFS').
                                        hiddenInput('','score_to_club_credit','hideSTC').
                                        hiddenInput('','club_credit_from_score','hideCFS').
                                        hiddenInput('','credit_to_club_score','hideCTS').
                                        hiddenInput('','club_score_from_credit','hideSFC').
                                        hiddenInput($Instance->getUserId(),'user_id','user_id').



                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }



    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
