<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use model\Entity\SocialMediasEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class ChargeCredit extends View
{

    public $SingularName = 'تراکنش';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('استارت آپ'),
                                                                    HtmlTags::Th('مشتری'),
                                                                    HtmlTags::Th('اعتبار پس از تراکنش'),
                                                                    HtmlTags::Th('امتیاز پس از تراکنش'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')

                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'startup_name' => new \model\Startups(),
                                                                    'customer_lname' => new \model\Customers(),
                                                                    'score_after' ,
                                                                    'credit_after' ,
                                                                ], false, false, false))

                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        $Instance = UserObject::instance();

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('مشتری ') .
                                        $this->Html()->Select('customer_id', 'customer_id', \model\Customers::toOption(),false) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز') .
                                        $this->Html()->Number('score_before','score_before',0,false) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('اعتبار') .
                                        $this->Html()->Price('credit_before','credit_before','تومان',0,false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        '
                                         <br>  <br>
                                         <div class="scoreBox">
                                          <div class="card text-white" style="background-color: #41b8cc">
                                          <div id="scoreBTN" type="button" class="btn btn-outline-dark btn-lg">  تخصیص امتیاز  <span class="badge badge-warning">کلیک کنید</span></div>
                                        
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تخصیص امتیاز','','toggles1') .
                                        '<div class="input-group-append toggles3">'.
                                        $this->Html()->Number('new_score','new_score','',false) .
                                        '<span type="button" class="toggles4 btn btn-success">محاسبه</span>'.
                                        '</div>'.
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز جدید نگاهاب','score_after','toggles2') .
                                        $this->Html()->Number('score_after','score_after',0,false) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(12) .
                                        '
                                         <br>  <br>
                                         <div class="creditBox">
                                          <div class="card text-white" style="background-color: #41b8cc">
                                          <div id="creditBTN" type="button" class="btn btn-outline-dark btn-lg">  تخصیص اعتبار  <span class="badge badge-warning">کلیک کنید</span></div>
                                        
                                           </div>
                                           </div>
                                         ' .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(  4,'sss') .
                                        $this->Html()->Label('تخصیص اعتبار','','togglec1') .
                                        '<div class="input-group-append togglec3">'.
                                        $this->Html()->Number('new_credit','new_credit','',false) .
                                        '<span type="button" class="togglec4 btn btn-success">محاسبه</span>'.
                                        '</div>'.
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(4 ) .
                                        $this->Html()->Label('اعتبار جدید نگاهاب','credit_after','togglec2') .
                                        $this->Html()->Number('credit_after','credit_after',0,false) .
                                        $this->Html()->FormGroupEnd() .

                                        hiddenInput($Instance->getUserId(),'user_id','user_id').

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

//    private function Table()
//    {
//        $data = json_decode($this->getData()->social_media_ids, true);
//        $this->initDataTable = false;
//
//        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
//            HtmlTags::Thead()->Content(
//                HtmlTags::Tr()->Content(
//                    HtmlTags::Th('.no-sort')->Content("ردیف"),
//                    HtmlTags::Th('.no-sort')->Content("#"),
//                    HtmlTags::Th()->Content("نام شبکه"),
//                    HtmlTags::Th()->Content("آیکون")->Width('100'),
//                    HtmlTags::Th('.no-sort')->Content("آدرس")
//                )
//            ),
//            HtmlTags::Tbody()->Content(
//
//                function () use ($data) {
//                    $row = '0';
//                    $output = [];
//                    /** @var SocialMediasEntity $socialMedia */
//                    foreach (\model\SocialMedias::getAll() as $socialMedia) {
//                        $image = $socialMedia->social_media_icon;
//                        $row++;
//                        $output[] = HtmlTags::Tr()->Content(
//                            HtmlTags::Td()->Content("$row"),
//                            HtmlTags::Td()->Content(
//                                HtmlTags::Input()
//                                    ->Attrs(['checked' => isset($data[$socialMedia->social_media_id])])
//                                    ->Type('checkbox')->Class('socialMediaCheckBox')
//                            ),
//                            HtmlTags::Td()->Content(
//                                $socialMedia->social_media_name
//                            ),
//                            HtmlTags::Td()->Content(
//                                '<img src="src/images/SocialMedias/' . $image . '"style="width: 100px;height=100px">'
//                            ),
//                            HtmlTags::Td()->Content(
//                                $this->Html()->Input("social_media_ids[$socialMedia->social_media_id]")->Disabled(!isset($data[$socialMedia->social_media_id]))->Required(false)
//                            )
//                        );
//                    }
//                    return $output;
//                }
//            )
//        );
//    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
