<?

namespace view;

use View;
use DOMWrap\Document;
use model\Entity\LevelsEntity;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\SocialMediaServicesEntity;

class SocialMediaServices extends View {
	
	public $initDataTable = false;
	public $SingularName = 'سرویس شبکه اجتماعی';
	public $PluralName = 'سرویس شبکه های اجتماعی';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کد سرویس'),
																	HtmlTags::Th('نام سرویس'),
																	HtmlTags::Th('دسته بندی'),
																	HtmlTags::Th('درصد سود'),
																	HtmlTags::Th('قیمت اصلی'),
																	HtmlTags::Th('فیمت نگاهاب')
//																	,
//																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->buildBody($this->getData())
															)
													)
											)
									)
							)
						)
				);
	}
	
	private function buildBody($data, $levels = []) {
		return collect($data)->map(function ($item, $i) use ($levels) {
			$service = \model\SocialMediaServices::getOneFiltered('service_id', $item->service);
			$value = $service instanceof SocialMediaServicesEntity ? $service->media_service_percent : 30;
			return HtmlTags::Tr()->Content(
				HtmlTags::Td('.no-sort')->Content($i + 1 . '')->Width(50),
				HtmlTags::Td()->Content($item->service),
				HtmlTags::Td()->Content($item->name),
				($this->State() != 'levelDiscounts' ?
					(
						HtmlTags::Td()->Content($item->category) .
						HtmlTags::Td('.priceContainer')->Data_('service', $item->service)->Content(
							HtmlTags::Span('.pricePlaceHolder')->Content($value . '%'),
							HtmlTags::Input('.form-control.priceInput.text-center')->Value($value)->Attrs(
								[
									'style' => 'display: none;',
								])->Data_('old', $value)
						) .
						HtmlTags::Td('.mainPrice')->Data_('price', ((int)$item->rate) . '')->Content(price_format((int)$item->rate)) .
						HtmlTags::Td('.newPrice')->Content(price_format((int)$item->rate + (((int)$item->rate) * $value) / 100))
					) : collect($levels)->map(function (LevelsEntity $level) use ($item, $service) {
						$percent = 0;
						if ($service instanceof SocialMediaServicesEntity) {
							$levels = json_decode($service->levels, true);
							if (isset($levels[$level->startup_id])) {
								if (isset($levels[$level->startup_id][$level->level_id])) {
									$percent = $levels[$level->startup_id][$level->level_id];
								}
							}
						}
						return HtmlTags::Td('.priceContainer')->Data_('service', $item->service)->Data_('level', $level->level_id)->Content(
							HtmlTags::Span('.pricePlaceHolder')->Content($percent >= 0 ? "$percent%" : 'غیرفعال'),
							HtmlTags::Input('.form-control.priceInput.text-center')->Value( "$percent")->Attrs(
								[
									'style' => 'display: none;',
								])->Data_('old', "$percent")
						);
					})->join('')
				)
			);
		})->join('');
	}
	
	public function levelDiscounts(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Div('.card.w-100.card-primary.card-outline.mt-3')->Content(
													HtmlTags::Div('.card-header')->Content(
														HtmlTags::Ul('.nav.nav-tabs.mt-2')->Content(
															$this->tabList()
														)
													)->Style(Style::raw([
														'direction'       => 'rtl',
														'justify-content' => 'space-evenly',
													])),
													HtmlTags::Div('.card-body')->Content(
														$this->tabView()
													)
												)
											)
									)
							)
						)
				);
	}
	
	private function tabList() {
		return $this->tabItems()->map(function ($item) {
			return $this->_buildTab($item);
		})->all();
	}
	
	private function tabItems() {
		return collect($this->getData()[0]);
	}
	
	private function _buildTab($item) {
		return
			HtmlTags::Li()->Content(
				HtmlTags::A('.tabLink')->Content(
					$item['name']
				)->Rel("tab_{$item['id']}")
			);
	}
	
	private function tabView() {
		return $this->tabItems()->map(function ($item) {
			
			return $this->_buildTabItem($item);
		})->all();
	}
	
	private function _buildTabItem($item) {
		return HtmlTags::Div(".tab.row#tab_{$item['id']}")->Content(
			HtmlTags::Table('.table.table-bordered.table-striped')
				->Content(
					HtmlTags::Thead('.table-dark')
						->Content(
							HtmlTags::Tr()->Content(
								HtmlTags::Th('ردیف')->Width('50'),
								HtmlTags::Th('نام سرویس'),
								HtmlTags::Th('دسته بندی'),
								collect($item->levels->all())->map(function (LevelsEntity $level) {
									return HtmlTags::Th($level->title);
								})->join('')
							)
						),
					HtmlTags::Tbody()
						->Content(
							$this->buildBody($this->getData()[1], $item->levels->all())
						)
				)
		);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('کد سرویس') .
										$this->Html()->Input('service_id') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('درصد سود') .
										$this->Html()->Input('social_media_service_percent') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
