$(function () {
    $(".priceContainer").on('dblclick', function () {
        let span = $(this).find('span');
        let input = $(this).find('input');

        if (!$(input).is(':visible')) {
            $(span).hide();
            $(input).data('saved', '0');

            $(input).show();
            $(input).focus();
        }
    })
    $(".priceInput").on('focusout', function () {
        let td = $(this).parents('td');
        save(td)
    })
    $(".priceInput").on('keyup', function (e) {
        if (e.which == 13) {
            let td = $(this).parents('td');
            save(td)
        }
    });

    const save = td => {

        let span = $(td).find('span');
        let input = $(td).find('input');
        if (input.data('saved') == '0') {
            if ($(input).is(':visible')) {
                $(input).hide();
                $(input).data('saved', '1');
                $(span).text($(input).val() + "%")
                $(span).show();
            }

            if ($(input).data('old') != $(input).val()) {
                $.loader();
                $.ajax({
                    url: 'controllers/SocialMedia/SocialMediaServices/SocialMediaServices',
                    type: 'post',
                    data: {
                        serviceId: $(td).data('service'),
                        percent: $(input).val(),
                        controller_type: 'savePrice',
                    },
                    success: res => {
                        $.loader();
                        $(input).data('old', $(input).val());
                        let tr = $(td).parents('tr');
                        let mainPrice = $(tr).find('.mainPrice').data('price');
                        $(tr).find('.newPrice').text(number_format(parseInt(mainPrice) + ((parseInt(mainPrice) * parseInt($(input).val())) / 100)).toFa() + ' تومان')
                    }
                })
            }
        }
    }
})
