<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class TransactionReports extends ReportView {
    public $SingularName = ' تراکنش';
    public $PluralName = ' تراکنشات';
    public function ReportFields(): array {
        $type =

            '<option value="chargeCredit" > تخصیص اعتبار </option>'.
            '<option value="chargeScore" > تخصیص امتیاز </option>'.
            '<option value="scoreToScore" > تبدیل امتیاز به امتیاز نگاهاب </option>'.
            '<option value="creditToScore" >تبدیل اعتبار به امتیاز نگاهاب </option>'.
            '<option value="scoreToCredit" > تبدیل امتیاز به اعتبار نگاهاب </option>'
        ;
        return  [
            $this->SimpleSelect('startup_id','استارت آپ',\model\Startups::toOption(),6),
            $this->SimpleSelect('customer_id','مشتری',\model\Customers::toOption(),6),
            $this->SimpleSelect('type','نوع تراکنش',$type,6),
            $this->DateFromTo("date",'تاریخ'),
//            $this->DateFromTo("credit",'اعتبار'),
//            $this->DateFromTo("score",'امتیاز'),
        ];
    }
    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نام استارت آپ")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("نام مشتری")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("امتیاز پیشین")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("امتیاز جدید")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("اعتبار پیشین")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("اعتبار جدید")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نوع تراکنش")->Style(new Style([Style\Props\Width::Em(13)]))
        );
    }

    public function makeRow($result)
    {
        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['startUpName']),
                            HtmlTags::Td()->Content($item['fullName']),
                            HtmlTags::Td()->Content($item['date']),
                            HtmlTags::Td()->Content($item['score_before']),
                            HtmlTags::Td()->Content($item['score_after']),
                            HtmlTags::Td()->Content($item['credit_before']),
                            HtmlTags::Td()->Content($item['credit_after']),
                            HtmlTags::Td()->Content($item['type'])
//                            HtmlTags::Td()->Content(
//                                HtmlTags::Button('.btn.btn-outline-info.m-1')->Content(
//                                    HtmlTags::I('.fa.fa-list')
//                                )->Data_('toggle', 'tooltip')->Title('جزئیات پذیرنده')->Attrs(["onclick"=>'action("/controllers/Customers/Customers?'.'customer_id'.'='.$item->customer_id.'")']))
                        );

                    }

                    return implode('',$output);
                }
            )
        );
    }

}
