<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;

use model\Entity\ProvidersEntity;

class ProviderReports extends ReportView {
    public $SingularName = 'تامین کننده';
    public $PluralName = 'کلی تامین کنندگان';

    public function ReportFields(): array {
        return  [

            $this->SimpleSelect('startup_id','استارت آپ',\model\Startups::toOption(),6),
            $this->SimpleSelect('provider_id','تامین کنندگان',\model\Providers::toOption(),6),
            $this->DateFromTo("date",'تاریخ قرارداد '),

        ];
    }

    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نام استارت آپ")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("پذیرندگان")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("مدیریت")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ شروع قرارداد")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("تاریخ پایان قرارداد")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("تخفیف نقدی")->Style(new Style([Style\Props\Width::Em(20)])),
            HtmlTags::Th()->Content("تخفیف اعتباری")->Style(new Style([Style\Props\Width::Em(20)]))
//            HtmlTags::Th()->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {


        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['startUpName']),
                            HtmlTags::Td()->Content($item['providerName']),
                            HtmlTags::Td()->Content($item['manager']),
                            HtmlTags::Td()->Content($item['dateStart']),
                            HtmlTags::Td()->Content($item['dateEnd']),
                            HtmlTags::Td()->Content($item['cashDiscount']),
                            HtmlTags::Td()->Content($item['creditDiscount'])
//                            HtmlTags::Td()->Content(HtmlTags::Button('.btn.btn-outline-info.m-1')->Content(HtmlTags::I('.fa.fa-list'))->Data_('toggle', 'tooltip')->Title('جزئیات پذیرنده')->Attrs(["onclick"=>'action("/controllers/Providers/Providers?'.'provider_id'.'='.$item->provider_id.'")']))
                        );

                    }

                    return implode('',$output);
                }
            )
        );
    }


}
