<?php
namespace view;
use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class CustomerReports extends ReportView {
    public $SingularName = 'مشتری';
    public $PluralName = 'مشتریان';
    public function ReportFields(): array {
        return  [
            $this->SimpleSelect('startup_id','استارت آپ',\model\Startups::toOption(),6),
            $this->SimpleSelect('customer_id','مشتری',\model\Customers::toOption(),6),
            $this->SimpleSelect('level_id','سطح عضویت',\model\Levels::toOption(),6),
            $this->DateFromTo("date",'تاریخ'),
            $this->DateFromTo("credit",'اعتبار'),
            $this->DateFromTo("score",'امتیاز'),
        ];
    }
    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نام استارت آپ")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("نام مشتری")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("سطح عضویت")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("تاریخ")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("اعتبار")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("امتیاز")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }

    public function makeRow($result)
    {
        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['startUpName']),
                            HtmlTags::Td()->Content($item['fullName']),
                            HtmlTags::Td()->Content($item['level']),
                            HtmlTags::Td()->Content($item['date']),
                            HtmlTags::Td()->Content($item['credit']),
                            HtmlTags::Td()->Content($item['score']),

                            HtmlTags::Td()->Content(
                                HtmlTags::Button('.btn.btn-outline-info.m-1')->Content(
                                HtmlTags::I('.fa.fa-list')
                                )->Data_('toggle', 'tooltip')->Title('جزئیات مشتری')->Attrs(["onclick"=>'action("/controllers/Customers/Customers?'.'customer_id'.'='.$item->customer_id.'")']))




                        );
                    }
                    return implode('',$output);
                }
            )
        );
    }

}
