<?php
namespace view;

use FwBase\Reports\ReportView;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;


class AgencyReports extends ReportView {
    public $SingularName = ' نمایندگان';

    public function ReportFields(): array {
        return  [
            $this->SimpleSelect('agency_id','نمایندگان',\model\Agencies::toOption(),4),
            $this->SimpleSelect('supervision_id','سرپرستی مناطق',\model\Supervisions::toOption(),4),
            $this->SimpleSelect('individual_id','مدیر ',\model\Individuals::toOption(),4),
        ];
    }
    public function thList() {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th('.no-sort')->Content("ردیف")->Style(new Style([Style\Props\Width::Em(7)])),
            HtmlTags::Th()->Content("نام نمایندگی")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("مدیر")->Style(new Style([Style\Props\Width::Em(10)])),
            HtmlTags::Th()->Content("سرپرستی مناطق")->Style(new Style([Style\Props\Width::Em(10)]))
//            HtmlTags::Th()->Content("جزئیات")->Style(new Style([Style\Props\Width::Em(15)]))
        );
    }
    public function makeRow($result)
    {
        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                $this->thList()
            ),
            HtmlTags::Tbody()->Content(
                function () use ($result){
                    $output = [];
                    foreach ($result as $item) {
                        $output[] = HtmlTags::Tr()->Content(
                            HtmlTags::Td(),
                            HtmlTags::Td()->Content($item['agencyName']),
                            HtmlTags::Td()->Content($item['managerName']),
                            HtmlTags::Td()->Content($item['supervisionName'])


//                            HtmlTags::Td()->Content(
//                                HtmlTags::Button('.btn.btn-outline-info.m-1')->Content(
//                                    HtmlTags::I('.fa.fa-list')
//                                )->Data_('toggle', 'tooltip')->Title('جزئیات نماینده')->Attrs(["onclick"=>'action("/controllers/Agencies/Agencies?'.'agency_id'.'='.$item->agency_id.'")']))

                        );
                    }
                    return implode('',$output);
                }
            )
        );
    }

}
