<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;

class ProviderLevels extends View {
	
	public $SingularName = 'سطح عضویت پذیرنده';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('عنوان سطح پذیرنده'), HtmlTags::Th('توضیحات سطح عضویت'), HtmlTags::Th('تفاضل با درصد تخفیف صنف'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'provider_level_name',
																	'provider_level_details',
																	'provider_level_difference',
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('عنوان سطح پذیرنده') .
										$this->Html()->Input('provider_level_name') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(8) .
										$this->Html()->Label('توضیحات سطح عضویت') .
										$this->Html()->Input('provider_level_details') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('آیکون سطح پذیرنده') .
										$this->Html()->ImageInput('provider_level_icon','image/png',150,150) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('از n درصد تخفیف صنف') .
										$this->Html()->Input('provider_level_difference_min') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تا n درصد تخفیف صنف') .
										$this->Html()->Input('provider_level_difference') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(5) .
										$this->Html()->Label('سطح عضویت همتا در باشگاه مشتریان') .
										$this->Html()->Select('level_id', 'level_id', \model\Levels::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('کد در استارتاپ') .
										$this->Html()->Input('provider_level_startup_code') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('استارتاپ') .
										$this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) .
										$this->Html()->FormGroupEnd() .
										HtmlTags::Div('.card.card-warning.card-outline.w-100')->Content(
											HtmlTags::Div('.card-header')->Content(
												HtmlTags::Div('.card-title')->Content(
													"مشارکت در درآمد"
												)
											),
											HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
												$this->Html()->FormGroupStart(5) .
												$this->Html()->Label('هر تراکنش در دستگاه کارتخوان متصل به باشگاه') .
												$this->Html()->Number('provider_level_transaction_on_pose', 'provider_level_transaction_on_pose') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(6) .
												$this->Html()->Label('هر ۱۰,۰۰۰ ریال تراکنش در دستگاه کارتخوان متصل به باشگاه') .
												$this->Html()->Number('provider_level_amount_transaction_on_pose') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(6) .
												$this->Html()->Label('هر بار بازدید از پنل فروش محصول در هرروز (حداکثر سه بار)') .
												$this->Html()->Number('provider_level_each_negashop_visit') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('معرفی هر محصول در پنل فروش') .
												$this->Html()->Number('provider_level_each_product_entry') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('فروش هر محصول در سایت اختصاصی') .
												$this->Html()->Number('provider_level_each_product_sale_in_site') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('فروش هر محصول در نگااپ') .
												$this->Html()->Number('provider_level_each_product_sale_in_negaapp') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(6) .
												$this->Html()->Label('هر ۱۰۰,۰۰۰ ریال تراکنش حاصل از فروش محصول در سایت اختصاصی') .
												$this->Html()->Number('provider_level_ten_thousand_product_sale_in_site') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(6) .
												$this->Html()->Label('هر ۱۰۰,۰۰۰ ریال تراکنش حاصل از فروش محصول در سامانه نگااپ') .
												$this->Html()->Number('provider_level_ten_thousand_product_sale_in_negaapp') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('ثبت هر مشتری در سیستم باشگاه مشتریان اختصاصی') .
												$this->Html()->Number('provider_level_each_customer_register') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('ثبت هر مشتری در سیستم باشگاه مشتریان اختصاصی') .
												$this->Html()->Number('provider_level_each_negacard_sale') .
												$this->Html()->FormGroupEnd()
											)
										),
										HtmlTags::Div('.card.card-primary.card-outline.w-100')->Content(
											HtmlTags::Div('.card-header')->Content(
												HtmlTags::Div('.card-title')->Content(
													"محاسبه امتیازات"
												)
											),
											HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('دریافت نگاکارت رایگان') .
												$this->Html()->Input('provider_level_free_negacard_yes_no') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۱۰ عددی') .
												$this->Html()->Percent('provider_level_ten_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۲۰ عددی') .
												$this->Html()->Percent('provider_level_twenty_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۵۰ عددی') .
												$this->Html()->Percent('provider_level_fifty_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۱۰۰ عددی') .
												$this->Html()->Percent('provider_level_hundred_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۵۰۰ عددی') .
												$this->Html()->Percent('provider_level_five_hundred_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در خرید بسته نگاکارت ۱,۰۰۰ عددی') .
												$this->Html()->Percent('provider_level_thousand_negacard_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('نمایش بج یا مدال در اپلیکیشن') .
												$this->Html()->Input('provider_level_show_badge_yes_no') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('رده معرفی بین اصناف مشابه') .
												$this->Html()->Number('provider_level_show_rate') .
												$this->Html()->FormGroupEnd() .
												HtmlTags::Div('.card.card-success.card-outline.w-100')->Content(
													HtmlTags::Div('.card-header')->Content(
														HtmlTags::Span('.card-title')->Content(
															'تخفیف در اجاره بنر معرفی در اپ قابل استفاده در هر ماه'
														)
													),
													HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار اول') .
														$this->Html()->Percent('provider_level_app_banner_discount[time_1]') .
														$this->Html()->FormGroupEnd() .
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار دوم') .
														$this->Html()->Percent('provider_level_app_banner_discount[time_2]') .
														$this->Html()->FormGroupEnd() .
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار سوم') .
														$this->Html()->Percent('provider_level_app_banner_discount[time_3]') .
														$this->Html()->FormGroupEnd()
													)
												),
												HtmlTags::Div('.card.card-success.card-outline.w-100')->Content(
													HtmlTags::Div('.card-header')->Content(
														HtmlTags::Span('.card-title')->Content(
															'تخفیف در تبلیغات فضای مجازی قابل استفاده در هر ماه'
														)
													),
													HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار اول') .
														$this->Html()->Percent('provider_level_social_media_discount[time_1]') .
														$this->Html()->FormGroupEnd() .
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار دوم') .
														$this->Html()->Percent('provider_level_social_media_discount[time_2]') .
														$this->Html()->FormGroupEnd() .
														$this->Html()->FormGroupStart(4) .
														$this->Html()->Label('بار سوم') .
														$this->Html()->Percent('provider_level_social_media_discount[time_3]') .
														$this->Html()->FormGroupEnd()
													)
												),
												
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('معرفی در بخش پذیرندگان منتخب') .
												$this->Html()->Select('provider_level_show_in_best_providers','provider_level_show_in_best_providers',collect([
													[
														'id' => "none",
														"title" => "ندارد",
													],
													[
														'id' => "city",
														"title" => "همراه با اصناف مشابه شهری",
													],
													[
														'id' => "state",
														"title" => "همراه با اصناف مشابه استانی",
													],
													[
														'id' => "country",
														"title" => "همراه با اصناف مشابه کشوری",
													]
												])->map(function ($item){
													return HtmlTags::Option()->Value($item['id'])->Content($item['title']);
												})->join('')) .
												$this->Html()->FormGroupEnd() .
												
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('امکان فروش در نگااپ') .
												$this->Html()->Input('provider_level_can_sell_in_negaapp_yes_no') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('امکان دریافت وبسایت رایگان') .
												$this->Html()->Select('provider_level_get_free_website','provider_level_get_free_website',collect([
													[
														'id' => "none",
														"title" => "ندارد",
													],
													[
														'id' => "basic-site",
														"title" => "سایت معرفی",
													],
													[
														'id' => "public-shop",
														"title" => "فروشگاهی عمومی",
													],
													[
														'id' => "exclusive-shop",
														"title" => "فروشگاهی اختصاصی",
													]
												])->map(function ($item){
													return HtmlTags::Option()->Value($item['id'])->Content($item['title']);
												})->join('')) .
												$this->Html()->FormGroupEnd() .
												
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('دامنه رایگان') .
												$this->Html()->Select('provider_level_get_free_domain','provider_level_get_free_domain',collect([
													[
														'id' => "none",
														"title" => "ندارد",
													],
													[
														'id' => "subdomain",
														"title" => "ساب دامین",
													],
													[
														'id' => "ir_domain",
														"title" => "دامنه ir",
													]
												])->map(function ($item){
													return HtmlTags::Option()->Value($item['id'])->Content($item['title']);
												})->join('')) .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('تخفیف در پنل پیامکی') .
												$this->Html()->Percent('provider_level_sms_panel_discount') .
												$this->Html()->FormGroupEnd() .
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('امکان دریافت باشگاه مشتریان اختصاصی') .
												$this->Html()->Input('provider_level_get_exclusive_club_yes_no') .
												$this->Html()->FormGroupEnd().
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('امکان دریافت نرم افزار مالی / اداری') .
												$this->Html()->Input('provider_level_get_accounting_yes_no') .
												$this->Html()->FormGroupEnd().
												$this->Html()->FormGroupStart(4) .
												$this->Html()->Label('امکان عضویت در استارتاپ های تخصصی نگارینه') .
												$this->Html()->Input('provider_level_can_register_in_startups_yes_no') .
												$this->Html()->FormGroupEnd()
											)
										),
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
