<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class ProductionToAccepters extends View
{

    public $SingularName = 'تخصیص محصول به پذیرنده';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('به ازای هرضریب'), HtmlTags::Th('قیمت'), HtmlTags::Th('توضیحات محصول'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['provider_to_product_for', 'provider_to_product_price', 'provider_to_product_description'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('گروه محصول') .
                                        $this->Html()->Select('product_group_id', 'product_group_id',\model\ProductGroups::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('زیر گروه محصول') .
                                        $this->Html()->Select('product_sub_group_id', 'product_sub_group_id', \model\ProductSubGroups::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('زیر زیر گروه محصول') .
                                        $this->Html()->Select('product_sub_sub_group_id', 'product_sub_sub_group_id',\model\ProductSubSubGroups::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام محصول') .
                                        $this->Html()->Select('product_id', 'product_id',\model\ProductsName::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('پذیرنده') .
                                        $this->Html()->Select('provider_id', 'provider_id', \model\Providers::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('شعبه پذیرنده') .
                                        $this->Html()->Select('provider_branch_id', 'provider_branch_id',\model\ProviderBranches::toOption()) .
                                        $this->Html()->FormGroupEnd() .



                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('واحد محصول') .
                                        $this->Html()->Select('unit_id', 'unit_id',\model\Units::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('به ازای هر') .
                                        HtmlTags::Label(".mr-2")->Content(
                                            " ضریب: ",
                                            HtmlTags::Span()->Id('for')
                                        ).
                                        $this->Html()->Input('provider_to_product_for')->Type('number')->Attrs(['step' => 1,'min' => 1,'max' => 1]) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('قیمت') .
                                        $this->Html()->Input('provider_to_product_price') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر محصول') .
                                        $this->Html()->ImageInput('provider_to_product_image', 'image/jpeg', 150, 150) .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('توضیحات محصول') .
                                        $this->Html()->TextArea('provider_to_product_description') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
