<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;

class CreditCards extends View {
	
	public $SingularName = 'کارت بانکی';
	public $PluralName = 'کارت های بانکی';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('شماره کارت'), HtmlTags::Th('cvv2'), HtmlTags::Th('ماه انقضا'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'credit_card_number',
																	'credit_card_cvv2',
																	'credit_card_expire_month',
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(8) .
										$this->Html()->Label('انتخاب مشتری') .
										$this->Html()->Select('customer_id', 'customer_id', \model\Customers::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('بانک') .
										$this->Html()->Select('bank_id', 'bank_id', \model\Banks::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(5) .
										$this->Html()->Label('شماره کارت') .
										$this->Html()->Number('credit_card_number', 'credit_card_number') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('cvv2') .
										$this->Html()->Number('credit_card_cvv2', 'credit_card_cvv2') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(2) .
										$this->Html()->Label('ماه انقضا') .
										$this->Html()->Number('credit_card_expire_month', 'credit_card_expire_month') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(2) .
										$this->Html()->Label('سال انقضا') .
										$this->Html()->Number('credit_card_expire_year', 'credit_card_expire_year') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document $document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document $document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document $document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
