<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;

class LatestNews extends View {
	
	public $SingularName = 'خبر';
	public $PluralName = 'آخرین اخبار';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('تیتر خبر'),
																	HtmlTags::Th('خلاصه توضیحات'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																	HtmlTags::Th('وضعیت')->Class('no-sort')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'latest_news_title',
																	'latest_news_summary',
																], true, true, true)
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(5) .
										$this->Html()->Label('تیتر خبر') .
										$this->Html()->Input('latest_news_title') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(7) .
										$this->Html()->Label('تصویر کاور') .
										$this->Html()->ImageInput('latest_news_cover', '4', 4, 4) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(8) .
										$this->Html()->Label('خلاصه توضیحات') .
										$this->Html()->Input('latest_news_summary') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('متن خبر') .
										$this->Html()->Input('latest_news_text') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
