<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;

class SimCardNumbers extends View {
	
	public $SingularName = 'پیش شماره سیم کارت';
	public $PluralName = 'پیش شماره های سیم کارت ها';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('اپراتور'),
																	HtmlTags::Th('پیش شماره'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'operator_name' => new \model\ChargeOperators(),
																	'sim_card_number',
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('پیش شماره') .
										$this->Html()->Number('sim_card_number', 'putSameWithName', '', true, false, 'form-control', 'text', $attrs = '', 99) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('خط اعتباری است') .
										$this->Html()->Input('sim_card_is_credit_yes_no') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب اپراتور') .
										$this->Html()->Select('charge_operator_id', 'charge_operator_id', selectByClass(new \model\ChargeOperators())) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
