<?

namespace view;

use View;
use DOMWrap\Document;
use FwPagination\Views\ViewPagination;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Castes extends View {
	use ViewPagination;
	
	public $SingularName = 'صنف';
	public $PluralName = 'اصناف';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndAdd()
											),
										$this->wrap(HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کد صنف'),
																	HtmlTags::Th('نام صنف'),
																	HtmlTags::Th('گروه کاری'),
																	HtmlTags::Th('درصد قرارداد'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																	HtmlTags::Th('.no-sort وضعیت')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'caste_id',
																	'caste_name',
																	'work_group_name' => new \model\WorkGroups,
																	'minimum_percent' => function($minimum_percent){
																	return $minimum_percent > 0 ? "$minimum_percent%" : HtmlTags::Span('.bg-danger.p-2')->Content(
																		"تعریف نشده"
																	);
																	},
																], false, true, true)
															)
													)
											)
										)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(''),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام صنف') .
										$this->Html()->Input('caste_name') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب گروه کاری') .
										$this->Html()->Select('workgroup_id', 'workgroup_id', \model\WorkGroups::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('آیکون صنف') .
										$this->Html()->ImageInput('caste_icon', 'image/jpeg', 150, 150, 'false', 'caste_icon', false) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('حداقل درصد قرارداد') .
										$this->Html()->Percent('minimum_percent') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
