<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;

class CasteGroupToStartup extends View {
	
	public $SingularName = 'تخصیص گروه صنفی به استارتاپ';
	public $PluralName = 'گروه های صنفی مربوط به هر استارتاپ';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام دسته'), HtmlTags::Th('کلید'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'caste_group_to_startup_name',
																	'caste_group_to_startup_key',
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام دسته') .
										$this->Html()->Input('caste_group_to_startup_name') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(5) .
										$this->Html()->Label('کلید') .
										$this->Html()->English('caste_group_to_startup_key') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('استارتاپ') .
										$this->Html()->Select('startup_id', 'startup_id', \model\Startups::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('اصناف') .
										$this->Html()->Select('caste_ids[]', 'caste_ids', \model\Castes::toOption(), true) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
