<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Banks extends View
{

    public $SingularName = 'بانک';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(''),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام بانک'),
                                                                    HtmlTags::Th('لوگو'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
//                                                                    HtmlTags::Th('.no-sort وضعیت')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['bank_name','showImage'=>'bank_logo'],false,true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(''),
                                    $this->Html()->refreshAndBack()
                                ),
                            $this->Html()->FormStart() .

                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('نام بانک') .
                            $this->Html()->Input('bank_name') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('لوگو') .
                            $this->Html()->ImageInput('bank_logo', 'image/jpeg', 150, 300, 'false', 'bank_name', false) .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('کد بانک در سرویس شارژ') .
                            $this->Html()->Input('bank_number') .
                            $this->Html()->FormGroupEnd() .
                            $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
