import {BaseRequest} from "./BaseRequest";
import {Symbols} from "../Base/Symbols/RequestSymbols";

export class Request  extends BaseRequest{
    static init(){
        return super[Symbols.initRequest]();
    }


    isPost() {
        this.method = 'post';
    }

    isGet() {
        this.method = 'get';
    }

    isPut() {
        this.method = 'put';
    }

    isPatch() {
        this.method = 'patch';
    }

    isDelete() {
        this.method = 'delete';
    }

    fromUrl(url){
        const pattern = new RegExp('^(https?:\\/\\/)?'+ // protocol
            '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // domain name
            '((\\d{1,3}\\.){3}\\d{1,3}))'+ // OR ip (v4) address
            '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // port and path
            '(\\?[;&a-z\\d%_.~+=-]*)?'+ // query string
            '(\\#[-a-z\\d_]*)?$','i'); // fragment locator
        if (!!pattern.test(url)) {
            this.url = url;
        }
    }
}
export const parsa = 'hoi';
