<?php
namespace model;
use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\IndividualsEntity;
use model\Entity\VisitorsEntity;

class Visitors  extends Model {
    public $_table = 'tblVisitors';
    public $_key = 'visitor_id';
    public $_Entity =  \model\Entity\VisitorsEntity::class;

    public static function toOption()
    {
        $output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
        /** @var IndividualsEntity $individual */
        /** @var VisitorsEntity $customer */
        foreach (self::getAll() as $customer) {

            $individual = Individuals::get($customer->individual_id);

            $output[] = HtmlTags::Option()->Value($customer->visitor_id)
                ->Content($individual->first_name . ' ' . $individual->last_name . ' - ' . $individual->mobile);

        }
        return implode('', $output);
    }

    public static function getByUserName(string $username) {
        return self::Db()->where('visitor_username', $username)->get()->first();
    }


}
