<?php

namespace model;

use FwConnection;
use DATABASE\Model;
use model\Entity\VoucherCodesEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\VoucherCodeProvidersEntity;

class VoucherCodes extends Model {
	public $_table = 'tblVoucherCodes';
	public $_key = 'voucher_code_id';
	public $_Entity = VoucherCodesEntity::class;
	

	public static function toOption(bool $showEmpty = true, iterable $data = NULL) {
		$output = [];
		/** @var VoucherCodeProvidersEntity $provider */
		foreach (self::getAllActives() as $code) {
			if ($code instanceof VoucherCodesEntity) {
				$provider = VoucherCodeProviders::get($code->code_provider_id);
				$output[] = HtmlTags::Option()->Value("$code->voucher_code_id")->Content(
					$code->code . " ({$code->code_count}) از {$provider->code_provider_name}"
				);
			}
		}
		return implode('', $output);
	}
	
	public static function selectDistinctDates() {
		$query = "SELECT DISTINCT `voucher_code_submit_date` FROM tblVoucherCodes";
		$conn = FwConnection::conn();
		$result = $conn->query($query);
		$output = [];
		while ($row = $result->fetchObject()) {
			$voucher_code_submit_date = $row->voucher_code_submit_date;
			$oneRow = $conn->query("SELECT * FROM tblVoucherCodes where voucher_code_submit_date = $voucher_code_submit_date")->fetchObject();
			$row->count = $conn->query("SELECT COUNT(*) as count from tblVoucherCodes where voucher_code_submit_date = $voucher_code_submit_date")->fetchObject()->count;
			$row->voucher_code_provider_id = $oneRow->voucher_code_provider_id;
			$row->percent = $oneRow->voucher_code_percent;
			$output[] = $row;
		}
		return $output;
	}
}
