<?php

namespace model;

use DATABASE\Model;
use model\Entity\StartupsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Startups extends Model {
	public $_table = 'tblStartups';
	public $_key = 'startup_id';
	public $_Entity = \model\Entity\StartupsEntity::class;
	
	
	public static function toOption(bool $showEmpty = true, iterable $data = NULL) {
		return parent::toOption($showEmpty, self::getAllActives());
	}
	
	/**
	 * @param string $startupToken
	 *
	 * @return StartupsEntity
	 */
	public static function getByToken(string $startupToken) {
		return self::getOneFiltered("token", $startupToken);
	}
	
	/**
	 * @param string $startupToken
	 *
	 * @return StartupsEntity
	 */
	public static function getByHashedId(string $startupToken) {
		return \FwConnection::conn()->query("SELECT * FROM tblStartups where MD5(startup_id) = '$startupToken'")->fetchObject(StartupsEntity::class);
	}
	
	protected function creditFromTo(string $name, string $label, int $size = 12) {
		$divided = $size / 2;
		$name = "fw_report_$name";
		return HtmlTags::Div(".form-group.col-md-$size")->Content(
			HtmlTags::Label($label),
			HtmlTags::Div('.d-flex.flex-wrap')->Content(
				HtmlTags::Div(".form-group.col-md-{$divided}")->Content(
					HtmlTags::Label('از'),
					HtmlTags::Input('.form-control')->Name("$name" . "_from")->Id("$name" . "_from")
				),
				HtmlTags::Div(".form-group.col-md-{$divided}")->Content(
					HtmlTags::Label('تا'),
					HtmlTags::Input('.form-control')->Name("$name" . "_to")->Id("$name" . "_to")
				)
			)
		);
	}
}
