<?php

namespace model;

use DATABASE\Model;
use model\Entity\StartupUsersEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class StartupUsers extends Model {
	public $_table = 'tblStartupUsers';
	public $_key = 'startup_user_id';
	public $_Entity = \model\Entity\StartupUsersEntity::class;
	
	public static function toOption() {
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		/** @var StartupUsersEntity $StartupUsers */
		foreach (self::getAllActives() as $StartupUsers) {
			$output[] = HtmlTags::Option()->Value("$StartupUsers->startup_user_id")->Content($StartupUsers->startup_user_name);
		}
		return implode('', $output);
	}
	
	public static function getByStartup($customer_id, Entity\StartupsEntity $startup) {
		return self::Db()->where([
			'customer_id' => $customer_id,
			'startup_id'  => $startup->id,
		])->get()->first;
	}
	
	public static function getByMobile($mobile) {
		return self::getOneFiltered('startup_user_mobile',$mobile);
	}
}
