<?php

namespace model;

use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CreditConversionEntity;
use model\Entity\CustomersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\StartupUsersEntity;

class TransactionReports extends Model
{
    public $_table = 'tblTransactionHistorys';
    public $_key = 'transaction_historys_id';
    public $_Entity = CreditConversionEntity::class;

    public static function getReport($startup_id, $customer_id, $start_date, $end_date, $type)
    {
        $query = self::Db();
        if ($startup_id) $query->where('startup_id', '=', $startup_id);
        if ($customer_id) $query->where('customer_id', '=', $customer_id);
        if ($start_date) {
            $query->where('transaction_historys_create', '>=', date("Y/m/d H:i:s", $start_date));
        }
        if ($end_date) {
            $query->where('transaction_historys_create', '<=', date("Y/m/d H:i:s", $end_date));
        }
        if ($type) {
            switch ($type) {
                case 'chargeCredit':
                    $query
                        ->where('credit_before != credit_after')
//                        ->where("score_after = score_before")
                        ->where('score_to_club_score IS NULL')
                        ->where('club_score_from_score IS NULL')
                        ->where('score_to_club_credit IS NULL')
                        ->where('club_credit_from_score IS NULL')
                        ->where('credit_to_club_score IS NULL')
                        ->where('club_score_from_credit IS  NULL');

                    break;
                case 'chargeScore':

                    $query
                        ->where("score_after != score_before")
//                        ->where('credit_before = credit_after')
                        ->where('score_to_club_score IS NULL')
                        ->where('club_score_from_score IS NULL')
                        ->where('score_to_club_credit IS NULL')
                        ->where('club_credit_from_score IS NULL')
                        ->where('credit_to_club_score IS NULL')
                        ->where('club_score_from_credit IS  NULL');

                    break;
                case 'creditToScore':

                    $query->where('credit_to_club_score IS NOT NULL')
                        ->where('club_score_from_credit IS NOT NULL')
                        ->where('credit_to_club_score != 0')
                        ->where('club_score_from_credit != 0');


                    break;
                case 'scoreToCredit':

                    $query->where('score_to_club_credit IS NOT NULL')
                        ->where('club_credit_from_score IS NOT NULL')
                        ->where('score_to_club_credit != 0')
                        ->where('club_credit_from_score != 0');


                    break;
                case 'scoreToScore':

                    $query->where('score_to_club_score IS NOT NULL')
                        ->where('club_score_from_score IS NOT NULL')
                        ->where('score_to_club_score != 0')
                        ->where('club_score_from_score != 0');

                    break;

            }

        }

        return $query->get();


    }
}