<?php
namespace model;
use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;
use model\Entity\StartupUsersEntity;

class ProviderReports  extends Model {
    public $_table = 'tblProviderToStartup';
    public $_key = 'provider_to_startup_id';
    public $_Entity =  \model\Entity\ProviderToStartupEntity::class;


    public static function getReport($start_date, $end_date, $startup_id, $provider_id)
    {
        $query = self::Db();
        if ($startup_id) $query->where('startup_id','=', $startup_id);
        if ($provider_id) $query->where('provider_id','=', $provider_id);
        if ($start_date) {
            $query->where('provider_to_startup_start_date', '>=', date("Y/m/d H:i:s",$start_date));
        }
        if ($end_date) {
            $query->where('provider_to_startup_start_date', '<=',  date("Y/m/d H:i:s",$end_date));
        }

        return $query->get();

    }


}