<?php

namespace model;

use DATABASE\Model;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;
use model\Entity\IndividualsEntity;
use model\Entity\StartupUsersEntity;

class CustomerReports extends Model
{
    public $_table = 'tblStartupUsers';
    public $_key = 'startup_user_id';
    public $_Entity = StartupUsersEntity::class;

    public static function getReport($start_date, $end_date, $startup_id,$start_credit,$end_credit,$start_score,$end_scoer,$level_id,$customer_id)
    {
        $query = self::Db();
        if ($startup_id) $query->where('startup_id','=', $startup_id);
        if ($customer_id) $query->where('customer_id','=', $customer_id);
        if ($start_date) {
            $query->where('startup_user_create', '>=', date("Y/m/d H:i:s",$start_date));
        }
        if ($end_date) {
            $query->where('startup_user_create', '<=',  date("Y/m/d H:i:s",$end_date));
        }
        if ($start_credit) {
            $query->where('startup_user_credit', '>=',$start_credit);
        }
        if ($end_credit) {
            $query->where('startup_user_credit', '<=',$end_credit);
        }
        if ($start_score) {
            $query->where('startup_user_score', '>=',$start_score);
        }
        if ($end_scoer) {
            $query->where('startup_user_score', '<=',$end_scoer);
        }
        $output = [];
        /** @var StartupUsersEntity $startUpUser */
            /** @var CustomersEntity $customer */
        foreach ($query->get() as $startUpUser){
            $customer = Customers::get($startUpUser->customer_id);
            if (($level_id and $customer->level_id == $level_id) or !$level_id){
                $output[] = $startUpUser;
            }
        }
        return $output;
    }

}