<?php

namespace model;

use DATABASE\Model;
use model\Entity\ProviderToStartupEntity;

class ProviderToStartup extends Model {
	public $_table = 'tblProviderToStartup';
	public $_key = 'provider_to_startup_id';
	public $_Entity = ProviderToStartupEntity::class;
	
	public static function getByStartup(string $providerId, Entity\StartupsEntity $startup) {
		return self::Db()->where([
			'provider_id' => $providerId,
			'startup_id'  => $startup->id,
		])->get()->first;
	}
	
	public static function getWithLimit($limit) {
		$query = "SELECT * FROM tblCastes as caste left join tblProviderToStartup as startup on 1 = 1 left join tblProviders as provider on provider.provider_id = startup.provider_id and caste.caste_id = provider.caste_id where startup.startup_id = 39 and provider.provider_name != '' group by provider.provider_name order by provider.provider_name asc limit $limit";
		$res = self::Db()->custom($query);
		return $res->get();
	}
	
	public static function getProviderList(Entity\StartupsEntity $startup, $cityId, $casteId, $sortBy, $sortType, int $page, int $limit) {
		$offset = $page * $limit;
		$res = \FwConnection::conn()->query("SELECT count(*) as totalCount from (SELECT providerStartup.provider_id,providerStartup.startup_id FROM `tblProviderToStartup` as providerStartup
    		left JOIN tblProviders as provider
    		    on provider.provider_id = providerStartup.provider_id
			WHERE provider.caste_id = $casteId  and providerStartup.startup_id = {$startup->id}
			  AND providerStartup.provider_to_startup_cash_discount > 0
			  AND (SELECT COUNT(provider_branch_id)
				  FROM tblProviderBranches as providerBranch
				  WHERE providerBranch.provider_id = provider_id
				    AND providerBranch.city_id = $cityId) > 0) t");
		$totalCount = $res->fetchObject()->totalCount;
		$sortType = $sortType === 'asc' ? "ASC" : "DESC";
		$sortBy = self::getSortByQuery($sortBy);
		$query = "
		SELECT * FROM `tblProviderToStartup` as providerStartup
    		left JOIN tblProviders as provider
    		    on provider.provider_id = providerStartup.provider_id
			WHERE provider.caste_id = $casteId  and providerStartup.startup_id = {$startup->id}
			  AND providerStartup.provider_to_startup_cash_discount > 0
			  AND (SELECT COUNT(provider_branch_id)
				  FROM tblProviderBranches as providerBranch
				  WHERE providerBranch.provider_id = provider_id
				    AND providerBranch.city_id = $cityId) > 0
			ORDER BY $sortBy $sortType
			limit $limit Offset {$offset}
				    ";
		$res = self::Db()->custom($query);
		return [$totalCount, $res->get()];
	}
	
	private static function getSortByQuery($sortBy) {
		$query = "provider.provider_id";
		switch ($sortBy) {
			case "discount":
				$query = "providerStartup.provider_to_startup_cash_discount";
				break;
			case "view":
				$query = "providerStartup.provider_view";
				break;
			case "name":
				$query = "provider.provider_name";
				break;
		}
		return $query;
	}
	
}
