<?php

namespace model;

use DATABASE\Model;
use model\Entity\LevelsEntity;
use model\Entity\StartupsEntity;

class Levels extends Model {
	public $_table = 'tblLevels';
	public $_key = 'level_id';
	public $_Entity = \model\Entity\LevelsEntity::class;
	
	
	public static function findOrUse(string $level, StartupsEntity $startup) : string {
		$level = Levels::getOneFiltered("level_code", $level);
		return $level instanceof LevelsEntity
			? $level->level_id . ''
			: Levels::Db()
				->where('startup_id', $startup->id)
				->orderBy('level_id', 'asc')
				->limit(1)
				->get()->first->level_id . '';
	}
	
	public static function getActiveLevelsForStartup($startup_id) {
		$query = "SELECT * FROM tblLevels as levels left join tblActiveList as actives on actives.table_name = 'tblLevels' and actives.item_id = levels.level_id where levels.startup_id = $startup_id";
		return self::Db()->custom($query)->get()->map(function ($levels_entity) {
			$levels_entity = LevelsEntity::fromArray((array)$levels_entity);
			return $levels_entity->apiFormat();
		});
	}
	
	public static function byCodeAndStartup($level, StartupsEntity $startup) {
		return self::Db()->where([
			'level_code' => $level,
			'startup_id' => $startup->id,
		])->get()->first;
	}
	
}
