<?php

namespace model;

use DATABASE\Model;
use model\Entity\IndividualsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Individuals extends Model {
	public $_table = 'tblIndividuals';
	public $_key = 'individual_id';
	public $_Entity = IndividualsEntity::class;
	
	public static function toOption(bool $showEmpty = true, iterable $data = NULL) {
		
		$output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
		/** @var IndividualsEntity $individual */
		foreach (self::getAll() as $individual) {
			$output[] = HtmlTags::Option()->Value($individual->individual_id)->Content($individual->first_name . ' ' . $individual->last_name . ' - ' . $individual->mobile)
				->Data_('fname', $individual->first_name)
				->Data_('lname', $individual->last_name)
				->Data_('mobile', $individual->mobile);
		}
		return implode('', $output);
	}
	
	public static function getByMobile(string $mobile) {
		return Individuals::getOneFiltered("individual_mobile", $mobile);
	}
	
}
