<?php
namespace model;
use DATABASE\Model;
use model\Entity\IndividualsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CustomersEntity;

class Customers  extends Model implements \PayingUserInterface {
    public $_table = 'tblCustomers';
    public $_key = 'customer_id';
    public $_Entity =  \model\Entity\CustomersEntity::class;

    public static function toOption()
    {
        $output = [HtmlTags::Option()->Disabled()->Selected()->Content("لطفا یک مورد را انتخاب کنید")];
        /** @var CustomersEntity $customer */
        foreach (self::getAll() as  $customer) {

            $output[] = HtmlTags::Option()->Value( $customer->customer_id)
                ->Content($customer->first_name . ' ' .  $customer->last_name . ' - ' . $customer->mobile)
                ->Data_('fname' , $customer->first_name)
                ->Data_('lname',$customer->last_name)
                ->Data_('mobile', $customer->mobile);

        }

        return implode('', $output);
    }
	
	public static function quickAddMobile(string $mobile,string $type = 'ChangeBuyer') {
		/** @var IndividualsEntity $individual */
		$individual = Individuals::findOrCreate([
			'individual_gender' => 0,
			'individual_mobile' => $mobile,
			'country_id' => 0,
		]);
		$id = $individual->individual_id;
		return Customers::add([
			'customer_mobile' => $mobile,
			'individual_id' => $id,
			'customer_username' => "{$type}_$id",
			'level_id' => 0,
			'customer_status' => 1,
		]);
		
	}
	
	public static function getByMobile(string $mobile) {
		return self::getOneFiltered("customer_mobile",$mobile);
	}
	
	public static function getByIndividual($individual_id) {
		return Customers::getOneFiltered("individual_id","$individual_id");
	}
	
	public function UserMobile(int $user_id) : string {
		return self::get($user_id)->mobile;
	}
}
