<?php

namespace model;

use fwJson\Json;
use DATABASE\Model;
use PaymentInterface;
use FwCharge\ChargeClass;
use model\Entity\CustomersEntity;
use payment\helpers\ParsianPaymentHelpers;

class  PaymentTable extends Model implements PaymentInterface {
	public $_table = 'PaymentTable';
	public $_key = 'payment_id';
	
	public static function toDataModel($item) {
		$PaymentHelpers = new ParsianPaymentHelpers();
		return [
			'type'        => $PaymentHelpers->getType($item->payment_type),
			'gate'        => $item->payment_gate,
			'date'        => jdate("Y/m/d", strtotime($item->payment_sdate)),
			'hour'        => jdate("H:i", strtotime($item->payment_sdate)),
			'isSucceeded' => $item->payment_status == 1,
			'amount'      => price_format($item->payment_amount / 10),
			'code'        => $item->payment_resnum,
			'refnum'      => $item->payment_refnum,
		];
	}
	
	
	public function save(int $customer_id, int $total_amount, string $resNum, Json $orderData, string $type) : bool {
		if ($id = $this::add([
			'customer_id'        => $customer_id,
			'payment_amount'     => $total_amount,
			$this->ResNumField() => $resNum,
			'payment_date'       => time(),
			'payment_type'       => $type,
			'payment_gate'       => 'پارسیان',
			'payment_data'       => $orderData->jsonSerialize(),
		])) {
			if ($type == ChargeClass::buyChargePayType) {
				$ChargeClass = new ChargeClass();
				$mobile = Customers::get($customer_id)->mobile;
				return $ChargeClass->save($customer_id,
					self::LastId(),
					$resNum,
					$total_amount,
					$mobile,
					$orderData->Decode()->callback
				);
			} elseif ($type == ChargeClass::buyPackagePayType) {
				$ChargeClass = new ChargeClass();
				/** @var CustomersEntity $customer */
				$customer = Customers::get($customer_id);
				$mobile = $customer->mobile;
				return $ChargeClass->savePackage($customer_id,
					self::LastId(),
					$orderData->Decode()->packageCode,
					$orderData->Decode()->packageCost,
					$resNum,
					
					$total_amount,
					
					$mobile,
					
					$orderData->Decode()->callback
				);
			} elseif ($type == 'provider_payment') {
				$mobile = Customers::get($customer_id)->mobile;
				return ProviderPayments::add([
					'provider_payment_mobile'   => $mobile,
					'provider_id'               => $orderData->Decode()->provider_id,
					'startup_id'                => $orderData->Decode()->startup_id,
					'provider_payment_date'     => time(),
					'payment_id'                => $id,
					'provider_payment_resnum'   => $orderData->Decode()->resNum,
					'provider_payment_status'   => '-1',
					'provider_payment_callback' => $orderData->Decode()->callback,
					'provider_payment_amount'   => $total_amount,
				]);
			}
		}
		return false;
	}
	
	public function ResNumField() : string {
		return 'payment_resnum';
	}
	
	public function RefNumField() : string {
		return 'payment_refnum';
	}
}
