<?php

namespace model;

use PDO;
use DATABASE\Model;
use helpers\DayHelper;
use FwBase\Reports\ReportScheme;
use model\Entity\NegaShopCitiesEntity;
use helpers\NeganoonPaymentTypeHelper;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class NegaShopStartups extends Model {
	public $_table = 'tblNegaShopStartups';
	public $_key = 'nega_shop_startup_id';
	public $_Entity = \model\Entity\NegaShopStartupsEntity::class;
	
	public static function withStartup() {
		$query = "SELECT * FROM tblNegaShopStartups as negashop left join tblStartups as startup on startup.startup_id = negashop.startup_id";
		$res = \FwConnection::conn()->query($query);
		$output = [];
		while ($row = $res->fetchObject()) {
			$output[] = $row;
		}
		return $output;
	}
	
	public static function groupsByNegaShop($nega_shop_startup_id, $hubCityId) {
		/** @var NegaShopCitiesEntity $negashop */
		$negashop = NegaShopCities::Db()->where([
			'nega_shop_startup_id' => $nega_shop_startup_id,
			'city_id'              => $hubCityId,
		])->get()->first;
		$categories = [];
		switch ($nega_shop_startup_id) {
			case 1:
				$categories = self::getNegaNoonCategories($negashop->nega_shop_city_id);
				break;
			case 2:
				$categories = self::getNegaMarket($negashop->nega_shop_city_id);
				break;
		}
		return $categories;
	}
	
	public static function getNegaNoonCategories($cityId) {
		$conn = self::getNoonConn();
		$output = [];
		if (!$cityId) return $output;
		$res = $conn->query("SELECT * FROM tblProductGroups where city_ids like '%\"$cityId\"%'");
		while ($row = $res->fetchObject()) {
			if (self::isNeganoonActive($conn, $row)) {
				$output[] = [
					'id'        => $row->product_group_id,
					'generalId' => "1_" . $row->product_group_id,
					'name'      => $row->product_group_name,
					'image'     => "https://meyt.neganoon.ir/admin/src/images/ProductGroups/" . $row->product_group_image,
				];
			}
		}
		return $output;
	}
	
	public static function getNoonConn() {
		$conn = new PDO("mysql:host=neganoon.ir;dbname=neganoon_newdb;charset=utf8", 'neganoon_newdb', 'pb@1105913561383', [PDO::ATTR_PERSISTENT => true]);
//		$conn->setAttribute(PDO::ATTR_ERRMODE, $ErrorMode);
		$conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		$conn->exec("set names utf8");
		return $conn;
	}
	
	public static function isNeganoonActive($conn, $item, $table = 'tblProductGroups', $key = 'product_group_id') {
		if ($conn->query("select * from `tblActiveList` where `table_name` = '{$table}' and `item_id` = '{$item->$key}'")->fetchObject()) {
			return true;
		}
		return false;
	}
	
	public static function getNegaMarket($cityId) {
		$conn = self::getMarketConn();
		$output = [];
		if (!$cityId) return $output;
		$res = $conn->query("SELECT * FROM tblProductGroups where city_id = $cityId");
		while ($row = $res->fetchObject()) {
			if (self::isNegaMarketActive($conn, $row)) {
				$output[] = [
					'id'        => $row->product_group_id,
					'generalId' => "1_" . $row->product_group_id,
					'name'      => $row->product_group_name,
					'image'     => "https://new.negamarket.ir/admin/src/images/ProductGroups/" . $row->product_group_image,
				];
			}
		}
		return $output;
	}
	
	public static function getMarketConn() {
		$conn = new PDO("mysql:host=negamarket.ir;dbname=negamarket_new;charset=utf8", 'negamarket_new2', 'mb@110591356', [PDO::ATTR_PERSISTENT => true]);
//		$conn->setAttribute(PDO::ATTR_ERRMODE, $ErrorMode);
		$conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		$conn->exec("set names utf8");
		return $conn;
	}
	
	public static function isNegaMarketActive($conn, $item) {
		$table = 'tblProductGroups';
		$key = 'product_group_id';
		if ($conn->query("select * from `tblActiveList` where `table_name` = '{$table}' and `item_id` = '{$item->$key}'")->fetchObject()) {
			return true;
		}
		return false;
	}
	
	public static function getGroupProducts($startupId, $groupId, $cityId, $subGroupId) {
		
		switch ($startupId) {
			case 1:
				$conn = self::getNoonConn();
				$products = self::getNoonProducts($conn, $groupId, $cityId);
				$pGroup = $conn->query("SELECT * FROM tblProductGroups where product_group_id = $groupId")->fetchObject();
				$pGroup = [
					'id'    => $pGroup->product_group_id,
					'name'  => $pGroup->product_group_name,
					'image' => "https://meyt.neganoon.ir/admin/src/images/ProductGroups/" . $pGroup->product_group_image,
				];
				$subGroups = [];
				break;
			case 2:
				$conn = self::getMarketConn();
				$products = self::getNegamarketProducts($conn, $groupId, $cityId, $subGroupId);
				$pGroup = $conn->query("SELECT * FROM tblProductGroups where product_group_id = $groupId")->fetchObject();
				$pGroup = [
					'id'    => $pGroup->product_group_id,
					'name'  => $pGroup->product_group_name,
					'image' => "https://new.negamarket.ir/admin/src/images/ProductGroups/" . $pGroup->product_group_icon,
				];
				$result = $conn->query("SELECT * FROM tblProductSubGroups where product_group_id = $groupId");
				$subGroups = [];
				while ($row = $result->fetchObject()) {
					$subGroups[] = [
						'id'   => $row->product_sub_group_id,
						'name' => $row->product_sub_group_name,
						'image' => "https://new.negamarket.ir/admin/src/images/ProductSubGroups/" . $row->product_sub_group_icon,
					];
				}
		}
		return [
			($pGroup['id'] > 0 ? $pGroup : NULL),
			$subGroups,
			$products,
		];
	}
	
	public static function getNoonProducts(PDO $conn, $groupId, $cityId) {
		$res = $conn->query("SELECT * FROM tblProducts as product left join tblProductNames as pname on pname.product_name_id = product.product_name_id left join tblUnits as unit on unit.unit_id = product.unit_id where product.product_group_id = $groupId and product.city_id = $cityId");
		$output = [];
		if (!$cityId) return $output;
		while ($row = $res->fetchObject()) {
			$output[] = [
				'id'      => $row->product_id,
				'name'    => $row->product_name,
				'unit'    => $row->unit_name,
				'factor'  => $row->product_factor,
				'details' => $row->product_details,
				'price'   => $row->product_price,
				'image'   => "https://meyt.neganoon.ir/admin/src/images/Products/" . $row->product_image,
			];
		}
		return $output;
	}
	
	public static function getNegamarketProducts(PDO $conn, $groupId, $cityId, $subGroupId) {
		$res = $conn->query("SELECT * FROM tblProducts as product left join tblProductsName as pname on pname.product_name_id = product.product_name_id left join tblUnits as unit on unit.unit_id = product.unit_id where product.product_group_id = $groupId and (product.product_sub_group_id = $subGroupId or $subGroupId = 0) and product.city_id = $cityId");
		$output = [];
		if (!$cityId) return $output;
		while ($row = $res->fetchObject()) {
			$output[] = [
				'id'      => $row->product_id,
				'name'    => $row->product_name,
				'unit'    => $row->unit_name,
				
				'factor'  => $row->product_factor,
				'details' => $row->product_details,
				'price'   => $row->product_price,
				'image'   => "https://new.negamarket.ir/admin/src/images/Products/" . $row->product_image,
			];
		}
		return $output;
	}
	
	public static function getSendingTimes(string $startupId, $list, $cityId) {
		$list = array_unique($list);
		switch ($startupId) {
			case 1:
				return self::getNoonSendingTimes($list, $cityId);
				break;
		}
	}
	
	public static function getNoonSendingTimes(array $list, $cityId) {
		$conn = self::getNoonConn();
		$productsByGroup = [];
		$groups = [];
		$implode = '(' . implode(',', $list) . ')';
		$res = $conn->query("SELECT * FROM tblProducts as product left join tblProductNames as pname on pname.product_name_id = product.product_name_id left join tblUnits as unit on unit.unit_id = product.unit_id left join tblProductGroups as pgroup on pgroup.product_group_id = product.product_group_id where product.product_id in $implode ");
		while ($row = $res->fetchObject()) {
			$productsByGroup[$row->product_group_id]['group'] = [
				'id'        => $row->product_group_id,
				'generalId' => "1_" . $row->product_group_id,
				'name'      => $row->product_group_name,
				'type'      => 'group',
				'image'     => "https://meyt.neganoon.ir/admin/src/images/ProductGroups/" . $row->product_group_image,
			];
			$groups[] = $row->product_group_id;
			if (!isset($productsByGroup[$row->product_group_id])) {
				$productsByGroup[$row->product_group_id] = ['products' => [],];
			}
			$productsByGroup[$row->product_group_id]['products'][] = [
				'id'      => $row->product_id,
				'name'    => $row->product_name,
				'unit'    => $row->unit_name,
				'factor'  => $row->product_factor,
				'details' => $row->product_details,
				'price'   => $row->product_price,
				'type'    => 'product',
				'image'   => "https://meyt.neganoon.ir/admin/src/images/Products/" . $row->product_image,
			];
		}
		$groupImplode = '(' . implode(',', $groups) . ')';
		$sendingTimes = $conn->query("SELECT * FROM tblSendingTimes where product_group_id in $groupImplode and city_id = $cityId");
		while ($row = $sendingTimes->fetchObject()) {
			
			if (!isset($productsByGroup[$row->product_group_id]['group']['sendingTimes'])) {
				$productsByGroup[$row->product_group_id]['group']['sendingTimes'] = [
					'today'    => [],
					'tomorrow' => [],
				];
			}
			if (self::isToday($row)) {
				$productsByGroup[$row->product_group_id]['group']['sendingTimes']['today'][] = [
					'id'    => $row->sending_time_id,
					'start' => $row->sending_time_start,
					'end'   => $row->sending_time_end,
					'label' => $row->sending_time_start . ' تا ' . $row->sending_time_end,
				];
			}
			if (DayHelper::isShiftOkForTommorow($row)) {
				$productsByGroup[$row->product_group_id]['group']['sendingTimes']['tomorrow'][] = [
					'id'    => $row->sending_time_id,
					'start' => $row->sending_time_start,
					'end'   => $row->sending_time_end,
					'label' => $row->sending_time_start . ' تا ' . $row->sending_time_end,
				];
			}
			usort($productsByGroup[$row->product_group_id]['group']['sendingTimes']['today'], function ($item, $next) {
				return explode(':', $item['start'])[0] > explode(':', $next['start'])[0];
			});
			usort($productsByGroup[$row->product_group_id]['group']['sendingTimes']['tomorrow'], function ($item, $next) {
				return explode(':', $item['start'])[0] > explode(':', $next['start'])[0];
			});
		}
		return $productsByGroup;
	}
	
	public static function isToday($row) {
		return DayHelper::isShiftOkForToday($row) and DayHelper::isShiftLeft([$row]);
	}
	
	public static function getPaymentTypes($startupId, $list, $nega_shop_city_id) {
		switch ($startupId) {
			case 1:
			default:
				return NeganoonPaymentTypeHelper::toApi();
				break;
		}
	}
	
	public static function getPrices($startupId, $list) {
		switch ($startupId) {
			case 1:
			default:
				$conn = self::getNoonConn();
				$totalPrice = 0;
				$implode = '(' . implode(',', $list) . ')';
				$res = $conn->query("SELECT * FROM tblProducts where product_id in $implode ");
				while ($row = $res->fetchObject()) {
					$totalPrice += $row->product_price;
				}
				return [
					'sendPrice'     => 5000,
					'packagePrice'  => 2000,
					'productsPrice' => $totalPrice,
					'totalPrice'    => $totalPrice + 7000,
				];
		}
	}
	
	public static function chooseDeliveryForOrder($district_id, $sending_time_id, $date, \PDO $conn) {
		$beginDate = strtotime("today", $date);
		$endDate = strtotime("tomorrow", $beginDate);
		$output = [];
		foreach (self::getDeliveriesByDistrictId($district_id, $conn) as $delivery) {
			$count = self::countDeliveryForTime($beginDate, $endDate, $sending_time_id, $delivery->delivery_id, $conn);
			$output[$delivery->delivery_id] = $count;
		}
		asort($output);
		foreach ($output as $delivery_id => $count) {
			return $delivery_id;
		}
	}
	
	public static function getDeliveriesByDistrictId($districtId, \PDO $conn) {
		$output = [];
		$Delivery = Db::table('tblDeliveries')->setNewConn($conn);
		foreach ($Delivery->get() as $delivery) {
			if (NegaShopStartups::isNeganoonActive($conn, $delivery, 'tblDeliveries', 'delivery_id')) {
				$district_ids = json_decode($delivery->district_ids, true);
				if (in_array($districtId, $district_ids)) {
					$output[] = $delivery;
				}
			}
		}
		return $output;
	}
	
	public static function countDeliveryForTime(int $beginOfDay, int $endOfDay, $sending_time_id, $delivery_id, PDO $conn) {
		$cond = ReportScheme::timeToQuery('orderShift.order_date', $beginOfDay, $endOfDay);
		$SendingTimes = Db::table('tblSendingTimes')->setNewConn($conn);
		$SendingTimes->reset();
		$sendingTime = $SendingTimes->where('sending_time_id', $sending_time_id)->get()->first;
		$SendingTimes->reset();
		$start = $sendingTime->sending_time_time_start;
		$end = $sendingTime->sending_time_time_end;
		$query = "SELECT * FROM `tblOrderShifts` as orderShift left join tblOrders as myOrder on orderShift.order_id = myOrder.order_id where  orderShift.delivery_id = '$delivery_id' and
                                               orderShift.time_start = '$start' and  orderShift.time_end = '$end'  and orderShift.deleted_at is NULL and myOrder.payment_status >= 0 and $cond ";
		return $conn->query($query)->rowCount();
	}
	
	public static function productsToOrderShiftInfo($district_id, $customer_address_latitude, $customer_address_longitude, $products, \PDO $conn) {
		$output = [];
		$Products = Db::table('tblProducts')->setNewConn($conn);
		$Units = Db::table('tblUnits')->setNewConn($conn);
		foreach ($products as $product_id => $productData) {
			
			if ($productData['count'] > 0) {
				$productInfo = $Products->where('product_id', $product_id)->get()->first;
				$Products->reset();
				$output[$product_id] = [
					'count'       => $productData['count'],
					'price'       => $productInfo->product_price,
					'unit'        => $Units->where('unit_id', $productInfo->unit_id)->get()->first->unit_name,
					'provider_id' => self::chooseProviderForOrder($district_id, $customer_address_latitude, $customer_address_longitude, $product_id, $conn),
					'isToday'     => $productData['isToday'],
				];
				$Units->reset();
			}
		}
		return json_encode($output, JSON_UNESCAPED_UNICODE);
	}
	
	public static function chooseProviderForOrder($district_id, $customer_address_latitude, $customer_address_longitude, $product_id, PDO $conn) {
		foreach (self::closestProvider($customer_address_latitude, $customer_address_longitude, $district_id, $conn) as $provider) {
			$products = json_decode($provider->provider_products, true);
			if (is_array($products)) {
				$keys = array_keys($products);
				if (in_array($product_id, $keys)) {
					return $provider->provider_id;
				}
			}
		}
		return 0;
	}
	
	public static function closestProvider($lat, $lng, $district_id, PDO $conn) {
		$Providers = Db::table('tblProviders')->setNewConn($conn);
		{
			if (!is_numeric($lat)) {
				$lat = 1.0;
			}
			if (!is_numeric($lng)) {
				$lng = 1.0;
			}
			if (!($lat > 0)) {
				$lat = 1.0;
			}
			if (!($lng > 0)) {
				$lng = 1.0;
			}
			$query = "SELECT *, SQRT( POW(69.1 * (provider_latitude - $lat), 2) + POW(69.1 * ($lng - provider_longitude) * COS(provider_latitude / 57.3), 2)) AS distance FROM tblProviders HAVING distance < 5000000 ORDER BY distance";
			$res = $conn->query($query);
			$output = [];
			while ($row = $res->fetchObject()) {
				if (NegaShopStartups::isNeganoonActive($conn, $row, 'tblProviders', 'provider_id')) {
					$district_ids = json_decode($row->district_id, true);
					if (in_array($district_id, $district_ids)) {
						$output[] = $row;
					}
				}
			}
			return $output;
		}
	}
	
	public static function sumProducts($products, PDO $conn) {
		$sum = 0;
		$Providers = Db::table('tblProducts')->setNewConn($conn);
		foreach ($products as $product_id => $productData) {
			if ($productData['count'] > 0) {
				
				$productInfo = $Providers->where('product_id', $product_id)->get()->first;
				$Providers->reset();;
				$factor = $productInfo->product_factor;
				if ($factor <= 0) {
					$factor = 1;
				}
				$sum += $productInfo->product_price * ($productData['count'] / $factor);
			}
		}
		return $sum;
	}
}
